/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.royale.compiler.asdoc.IASDocDelegate;
import org.apache.royale.compiler.clients.COMPC;
import org.apache.royale.compiler.clients.COMPJSCNative;
import org.apache.royale.compiler.clients.COMPJSCRoyale;
import org.apache.royale.compiler.clients.MXMLC;
import org.apache.royale.compiler.clients.MXMLJSC;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogCompcConfiguration;
import org.apache.royale.compiler.internal.parsing.as.RoyaleASDocDelegate;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.utils.ArgumentUtil;

public class COMPJSC
extends MXMLJSC {
    @Override
    public String getName() {
        return "COMPC";
    }

    @Override
    public int execute(String[] args) {
        return COMPJSC.staticMainNoExit(args);
    }

    public static void main(String[] args) {
        int exitCode = COMPJSC.staticMainNoExit(args);
        if (exitCode != ExitCode.WATCHING.getCode()) {
            System.exit(exitCode);
        }
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        COMPJSC mxmlc = new COMPJSC();
        mxmlc.configurationClass = JSGoogCompcConfiguration.class;
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        int exitCode = mxmlc.mainNoExit(args, problems, true);
        long endTime = System.nanoTime();
        System.out.println((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mainNoExit(String[] args, List<ICompilerProblem> problems, Boolean printProblems) {
        int exitCode = -1;
        try {
            exitCode = this._mainNoExit(ArgumentUtil.fixArgs((String[])args), problems);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        finally {
            if (problems != null && !problems.isEmpty() && printProblems.booleanValue()) {
                WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace);
                ProblemPrinter printer = new ProblemPrinter((ProblemFormatter)formatter);
                printer.printProblems(problems);
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _mainNoExit(String[] args, List<ICompilerProblem> outProblems) {
        ExitCode exitCode;
        block20: {
            Iterator<String> iterator;
            block19: {
                System.out.println("args:");
                for (String arg : args) {
                    System.out.println(arg);
                }
                exitCode = ExitCode.SUCCESS;
                try {
                    boolean continueCompilation = this.configure(args);
                    CompilerDiagnosticsConstants.diagnostics = this.config.getDiagnosticsLevel();
                    if (continueCompilation) {
                        iterator = this.config.getCompilerTargets().iterator();
                        break block19;
                    }
                    exitCode = this.problems.hasFilteredProblems() ? ExitCode.FAILED_WITH_CONFIG_PROBLEMS : ExitCode.PRINT_HELP;
                    break block20;
                }
                catch (Exception e) {
                    if (outProblems == null) {
                        System.err.println(e.getMessage());
                    } else {
                        UnexpectedExceptionProblem unexpectedExceptionProblem = new UnexpectedExceptionProblem((Throwable)e);
                        this.problems.add((ICompilerProblem)unexpectedExceptionProblem);
                    }
                    exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
                    return (int)exitCode;
                }
                finally {
                    if (!this.config.getWatch() || !ExitCode.SUCCESS.equals((Object)exitCode)) {
                        this.waitAndClose();
                    }
                    if (outProblems != null && this.problems.hasFilteredProblems()) {
                        for (ICompilerProblem problem : this.problems.getFilteredProblems()) {
                            outProblems.add(problem);
                        }
                    }
                    break block20;
                }
            }
            block12: while (iterator.hasNext()) {
                String target = iterator.next();
                int result = 0;
                switch (MXMLJSC.JSTargetType.fromString(target)) {
                    case SWF: {
                        System.out.println("COMPC");
                        COMPC compc = new COMPC();
                        this.mxmlc = compc;
                        compc.workspace.setASDocDelegate((IASDocDelegate)new RoyaleASDocDelegate(true));
                        compc.configurationClass = JSGoogCompcConfiguration.class;
                        result = compc.mainNoExit(this.removeJSArgs(args));
                        if (result == MXMLC.ExitCode.SUCCESS.getCode() || result == MXMLC.ExitCode.WATCHING.getCode()) break;
                        this.problems.addAll((Iterable)compc.problems.getProblems());
                        break block12;
                    }
                    case JS_ROYALE: {
                        System.out.println("COMPCJSCRoyale");
                        COMPJSCRoyale royale = new COMPJSCRoyale();
                        this.lastCompiler = royale;
                        result = royale.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                        if (result == COMPJSCRoyale.ExitCode.SUCCESS.getCode() || result == COMPJSCRoyale.ExitCode.WATCHING.getCode()) break;
                        break block12;
                    }
                    case JS_NATIVE: 
                    case JS_NODE: {
                        COMPJSCNative jsc = new COMPJSCNative();
                        this.lastCompiler = jsc;
                        result = jsc.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                        if (result != COMPJSCNative.ExitCode.SUCCESS.getCode() && result != COMPJSCNative.ExitCode.WATCHING.getCode()) break block12;
                    }
                }
            }
            if (this.problems.hasFilteredProblems() && this.problems.hasErrors()) {
                exitCode = ExitCode.FAILED_WITH_ERRORS;
            }
        }
        if (!this.config.getWatch()) return exitCode.getCode();
        if (!ExitCode.SUCCESS.equals((Object)exitCode)) return exitCode.getCode();
        exitCode = ExitCode.WATCHING;
        return exitCode.getCode();
    }

    @Override
    protected String getProgramName() {
        return "compc";
    }

    protected boolean isCompc() {
        return true;
    }

    @Override
    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWC;
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_ERRORS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4),
        WATCHING(1000);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }
}

