/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.apache.royale.compiler.targets;

import java.util.Collection;

import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.swf.ISWF;

/**
 * An {@link ITarget} than can build a SWF.
 */
public interface ISWFTarget extends ITarget
{
    /**
     * Adds frames and tags to those frames for all the content generated by the
     * target. When this method returns false, the {@linkplain ISWF} should be
     * considered invalid and the specified problemCollection should be searched
     * for the cause.
     * 
     * @param problems Collection to which all problems of all
     * CompilationUnits whose output is added to the specified ISWF are added.
     * @return ISWF if all tags generated by the target we added to the
     * specified SWF.
     */
    ISWF build(Collection<ICompilerProblem> problems);
}
