/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.samza.coordinator.server

import java.net.URL

import javax.servlet.http.{HttpServlet, HttpServletRequest, HttpServletResponse}
import org.apache.samza.util.{HttpUtil, Util}
import org.junit.Assert._
import org.junit.Test

class TestHttpServer {
  @Test
  def testHttpServerDynamicPort {
    val server = new HttpServer("/test", resourceBasePath = "scalate")
    try {
      server.addServlet("/basic", new BasicServlet())
      server.start
      val body = HttpUtil.read(new URL(server.getUrl + "/basic"))
      assertEquals("{}", body)
      val css = HttpUtil.read(new URL(server.getUrl + "/css/ropa-sans.css"))
      assertTrue(css.contains("RopaSans"))
    } finally {
      server.stop
    }
  }

  @Test
  def testHttpServerUrl {
    val server = new HttpServer("/test", resourceBasePath = "scalate")
    try {
      server.addServlet("/basic", new BasicServlet())
      server.start
      assertTrue(server.getUrl.getHost == Util.getLocalHost.getHostName)
    } finally {
      server.stop
    }
  }
}

class BasicServlet extends HttpServlet {
  override protected def doGet(request: HttpServletRequest, response: HttpServletResponse) {
    response.setContentType("application/json")
    response.setStatus(HttpServletResponse.SC_OK)
    response.getWriter.write("{}")
  }
}