/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.common;

import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.transform.common.AbstractSeaTunnelTransform;

public abstract class AbstractCatalogSupportTransform
extends AbstractSeaTunnelTransform {
    protected CatalogTable inputCatalogTable;
    protected volatile CatalogTable outputCatalogTable;

    public AbstractCatalogSupportTransform(@NonNull CatalogTable inputCatalogTable) {
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
        this.inputCatalogTable = inputCatalogTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CatalogTable getProducedCatalogTable() {
        if (this.outputCatalogTable == null) {
            AbstractCatalogSupportTransform abstractCatalogSupportTransform = this;
            synchronized (abstractCatalogSupportTransform) {
                if (this.outputCatalogTable == null) {
                    this.outputCatalogTable = this.transformCatalogTable();
                }
            }
        }
        return this.outputCatalogTable;
    }

    private CatalogTable transformCatalogTable() {
        TableIdentifier tableIdentifier = this.transformTableIdentifier();
        TableSchema tableSchema = this.transformTableSchema();
        return CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)tableSchema, (Map)this.inputCatalogTable.getOptions(), (List)this.inputCatalogTable.getPartitionKeys(), (String)this.inputCatalogTable.getComment());
    }

    protected abstract TableSchema transformTableSchema();

    protected abstract TableIdentifier transformTableIdentifier();
}

