/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.format.json.JsonToRowConverters;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.transform.common.MultipleFieldOutputTransform;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.exception.JsonPathTransformErrorCode;
import org.apache.seatunnel.transform.exception.TransformCommonError;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.jsonpath.ColumnConfig;
import org.apache.seatunnel.transform.jsonpath.JsonPathTransformConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathTransform
extends MultipleFieldOutputTransform {
    private static final Logger log = LoggerFactory.getLogger(JsonPathTransform.class);
    public static final String PLUGIN_NAME = "JsonPath";
    private static final Map<String, JsonPath> JSON_PATH_CACHE = new ConcurrentHashMap<String, JsonPath>();
    private final JsonPathTransformConfig config;
    private final SeaTunnelRowType seaTunnelRowType;
    private JsonToRowConverters.JsonToObjectConverter[] converters;
    private SeaTunnelRowType outputSeaTunnelRowType;
    private int[] srcFieldIndexArr;

    public JsonPathTransform(JsonPathTransformConfig config, CatalogTable catalogTable) {
        super(catalogTable);
        this.config = config;
        this.seaTunnelRowType = catalogTable.getSeaTunnelRowType();
        this.init();
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    private void init() {
        this.initSrcFieldIndexArr();
        this.initOutputSeaTunnelRowType();
        this.initConverters();
    }

    private void initConverters() {
        JsonToRowConverters jsonToRowConverters = new JsonToRowConverters(false, false);
        this.converters = (JsonToRowConverters.JsonToObjectConverter[])this.config.getColumnConfigs().stream().map(ColumnConfig::getDestType).map(jsonToRowConverters::createConverter).toArray(JsonToRowConverters.JsonToObjectConverter[]::new);
    }

    private void initOutputSeaTunnelRowType() {
        SeaTunnelDataType[] dataTypes = (SeaTunnelDataType[])this.config.getColumnConfigs().stream().map(ColumnConfig::getDestType).toArray(SeaTunnelDataType[]::new);
        this.outputSeaTunnelRowType = new SeaTunnelRowType((String[])this.config.getColumnConfigs().stream().map(ColumnConfig::getDestField).toArray(String[]::new), dataTypes);
    }

    private void initSrcFieldIndexArr() {
        List<ColumnConfig> columnConfigs = this.config.getColumnConfigs();
        HashSet<String> fieldNameSet = new HashSet<String>(Arrays.asList(this.seaTunnelRowType.getFieldNames()));
        this.srcFieldIndexArr = new int[columnConfigs.size()];
        for (int i = 0; i < columnConfigs.size(); ++i) {
            ColumnConfig columnConfig = columnConfigs.get(i);
            String srcField = columnConfig.getSrcField();
            if (!fieldNameSet.contains(srcField)) {
                throw TransformCommonError.cannotFindInputFieldError(this.getPluginName(), srcField);
            }
            this.srcFieldIndexArr[i] = this.seaTunnelRowType.indexOf(srcField);
        }
    }

    @Override
    protected Object[] getOutputFieldValues(SeaTunnelRowAccessor inputRow) {
        List<ColumnConfig> configs = this.config.getColumnConfigs();
        int size = configs.size();
        Object[] fieldValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            int pos = this.srcFieldIndexArr[i];
            fieldValues[i] = this.doTransform(this.seaTunnelRowType.getFieldType(pos), inputRow.getField(pos), configs.get(i), this.converters[i]);
        }
        return fieldValues;
    }

    private Object doTransform(SeaTunnelDataType<?> inputDataType, Object value, ColumnConfig columnConfig, JsonToRowConverters.JsonToObjectConverter converter) {
        if (value == null) {
            return null;
        }
        JSON_PATH_CACHE.computeIfAbsent(columnConfig.getPath(), x$0 -> JsonPath.compile(x$0, new Predicate[0]));
        String jsonString = "";
        try {
            switch (inputDataType.getSqlType()) {
                case STRING: {
                    jsonString = value.toString();
                    break;
                }
                case BYTES: {
                    jsonString = new String((byte[])value);
                    break;
                }
                case ARRAY: 
                case MAP: {
                    jsonString = JsonUtils.toJsonString((Object)value);
                    break;
                }
                case ROW: {
                    SeaTunnelRow row = (SeaTunnelRow)value;
                    jsonString = JsonUtils.toJsonString((Object)row.getFields());
                    break;
                }
                default: {
                    throw CommonError.unsupportedDataType((String)this.getPluginName(), (String)inputDataType.getSqlType().toString(), (String)columnConfig.getSrcField());
                }
            }
            Object result = JSON_PATH_CACHE.get(columnConfig.getPath()).read(jsonString);
            JsonNode jsonNode = JsonUtils.toJsonNode(result);
            return converter.convert(jsonNode, null);
        }
        catch (JsonPathException e) {
            throw new TransformException((SeaTunnelErrorCode)JsonPathTransformErrorCode.JSON_PATH_COMPILE_ERROR, e.getMessage());
        }
    }

    @Override
    protected Column[] getOutputColumns() {
        int len = this.outputSeaTunnelRowType.getTotalFields();
        Column[] columns = new Column[len];
        for (int i = 0; i < len; ++i) {
            String fieldName = this.outputSeaTunnelRowType.getFieldName(i);
            SeaTunnelDataType fieldType = this.outputSeaTunnelRowType.getFieldType(i);
            columns[i] = PhysicalColumn.of((String)fieldName, (SeaTunnelDataType)fieldType, (Integer)200, (boolean)true, (Object)"", (String)"");
        }
        return columns;
    }
}

