/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsConfig;
import com.hazelcast.aws.AwsCredentials;
import com.hazelcast.aws.AwsRequestUtils;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.utils.RestClient;
import java.util.Optional;

class AwsMetadataApi {
    private static final ILogger LOGGER = Logger.getLogger(AwsMetadataApi.class);
    private static final String EC2_METADATA_ENDPOINT = "http://169.254.169.254/latest/meta-data";
    private static final String ECS_IAM_ROLE_METADATA_ENDPOINT = "http://169.254.170.2" + System.getenv("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI");
    private static final String ECS_TASK_METADATA_ENDPOINT = System.getenv("ECS_CONTAINER_METADATA_URI");
    private static final String SECURITY_CREDENTIALS_URI = "/iam/security-credentials/";
    private final String ec2MetadataEndpoint;
    private final String ecsIamRoleEndpoint;
    private final String ecsTaskMetadataEndpoint;
    private final AwsConfig awsConfig;

    AwsMetadataApi(AwsConfig awsConfig) {
        this.ec2MetadataEndpoint = EC2_METADATA_ENDPOINT;
        this.ecsIamRoleEndpoint = ECS_IAM_ROLE_METADATA_ENDPOINT;
        this.ecsTaskMetadataEndpoint = ECS_TASK_METADATA_ENDPOINT;
        this.awsConfig = awsConfig;
    }

    AwsMetadataApi(String ec2MetadataEndpoint, String ecsIamRoleEndpoint, String ecsTaskMetadataEndpoint, AwsConfig awsConfig) {
        this.ec2MetadataEndpoint = ec2MetadataEndpoint;
        this.ecsIamRoleEndpoint = ecsIamRoleEndpoint;
        this.ecsTaskMetadataEndpoint = ecsTaskMetadataEndpoint;
        this.awsConfig = awsConfig;
    }

    String availabilityZoneEc2() {
        String uri = this.ec2MetadataEndpoint.concat("/placement/availability-zone/");
        return AwsRequestUtils.createRestClient(uri, this.awsConfig).get().getBody();
    }

    Optional<String> placementGroupEc2() {
        return this.getOptionalMetadata(this.ec2MetadataEndpoint.concat("/placement/group-name/"), "placement group");
    }

    Optional<String> placementPartitionNumberEc2() {
        return this.getOptionalMetadata(this.ec2MetadataEndpoint.concat("/placement/partition-number/"), "partition number");
    }

    private Optional<String> getOptionalMetadata(String uri, String loggedName) {
        RestClient.Response response;
        try {
            response = AwsRequestUtils.createRestClient(uri, this.awsConfig).expectResponseCodes(200, 404).get();
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Could not resolve the %s metadata", loggedName));
            return Optional.empty();
        }
        int responseCode = response.getCode();
        if (responseCode == 200) {
            return Optional.of(response.getBody());
        }
        if (responseCode == 404) {
            LOGGER.fine(String.format("No %s information is found.", loggedName));
            return Optional.empty();
        }
        throw new RuntimeException(String.format("Unexpected response code: %d", responseCode));
    }

    String defaultIamRoleEc2() {
        String uri = this.ec2MetadataEndpoint.concat(SECURITY_CREDENTIALS_URI);
        return AwsRequestUtils.createRestClient(uri, this.awsConfig).get().getBody();
    }

    AwsCredentials credentialsEc2(String iamRole) {
        String uri = this.ec2MetadataEndpoint.concat(SECURITY_CREDENTIALS_URI).concat(iamRole);
        String response = AwsRequestUtils.createRestClient(uri, this.awsConfig).get().getBody();
        return AwsMetadataApi.parseCredentials(response);
    }

    AwsCredentials credentialsEcs() {
        String response = AwsRequestUtils.createRestClient(this.ecsIamRoleEndpoint, this.awsConfig).get().getBody();
        return AwsMetadataApi.parseCredentials(response);
    }

    private static AwsCredentials parseCredentials(String response) {
        JsonObject role = Json.parse(response).asObject();
        return AwsCredentials.builder().setAccessKey(role.getString("AccessKeyId", null)).setSecretKey(role.getString("SecretAccessKey", null)).setToken(role.getString("Token", null)).build();
    }

    EcsMetadata metadataEcs() {
        String response = AwsRequestUtils.createRestClient(this.ecsTaskMetadataEndpoint, this.awsConfig).get().getBody();
        return this.parseEcsMetadata(response);
    }

    private EcsMetadata parseEcsMetadata(String response) {
        JsonObject metadata = Json.parse(response).asObject();
        JsonObject labels = metadata.get("Labels").asObject();
        String taskArn = labels.get("com.amazonaws.ecs.task-arn").asString();
        String clusterArn = labels.get("com.amazonaws.ecs.cluster").asString();
        return new EcsMetadata(taskArn, clusterArn);
    }

    static class EcsMetadata {
        private final String taskArn;
        private final String clusterArn;

        EcsMetadata(String taskArn, String clusterArn) {
            this.taskArn = taskArn;
            this.clusterArn = clusterArn;
        }

        String getTaskArn() {
            return this.taskArn;
        }

        String getClusterArn() {
            return this.clusterArn;
        }
    }
}

