/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.impl.AbstractQueryCacheConfigBuilderHelper;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.query.impl.IndexUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class QueryCacheXmlConfigBuilderHelper
extends AbstractQueryCacheConfigBuilderHelper {
    QueryCacheXmlConfigBuilderHelper(boolean domLevel3) {
        super(domLevel3);
    }

    @Override
    public void handleQueryCache(ClientConfig clientConfig, Node node) {
        for (Node queryCacheNode : DomConfigHelper.childElements(node)) {
            if (!this.matches("query-cache", DomConfigHelper.cleanNodeName(queryCacheNode))) continue;
            this.handleQueryCacheNode(clientConfig, queryCacheNode);
        }
    }

    @Override
    protected String getCacheName(Node queryCacheNode) {
        return this.getTextContent(this.getNamedItemNode(queryCacheNode, "name"));
    }

    @Override
    protected String getCacheMapName(NamedNodeMap attrs) {
        return this.getTextContent(this.getNamedItemNode(attrs, "mapName"));
    }

    @Override
    protected void handleEntryListeners(QueryCacheConfig queryCacheConfig, Node childNode) {
        for (Node listenerNode : DomConfigHelper.childElements(childNode)) {
            if (!this.matches("entry-listener", DomConfigHelper.cleanNodeName(listenerNode))) continue;
            this.handleEntryListenerNode(queryCacheConfig, listenerNode);
        }
    }

    @Override
    protected void queryCachePredicateHandler(Node childNode, QueryCacheConfig queryCacheConfig) {
        String predicateType = this.getTextContent(this.getNamedItemNode(childNode, "type"));
        String textContent = this.getTextContent(childNode);
        PredicateConfig predicateConfig = new PredicateConfig();
        if (this.matches("class-name", predicateType)) {
            predicateConfig.setClassName(textContent);
        } else if (this.matches("sql", predicateType)) {
            predicateConfig.setSql(textContent);
        }
        queryCacheConfig.setPredicateConfig(predicateConfig);
    }

    @Override
    protected void queryCacheIndexesHandle(Node n, QueryCacheConfig queryCacheConfig) {
        for (Node indexNode : DomConfigHelper.childElements(n)) {
            if (!this.matches("index", DomConfigHelper.cleanNodeName(indexNode))) continue;
            IndexConfig indexConfig = IndexUtils.getIndexConfigFromXml(indexNode, this.domLevel3, this.strict);
            queryCacheConfig.addIndexConfig(indexConfig);
        }
    }
}

