/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.impl.connection.tcp.ClientProtocolEncoder;
import com.hazelcast.client.impl.connection.tcp.TcpClientConnection;
import com.hazelcast.client.impl.protocol.util.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.util.ClientMessageEncoder;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.ChannelOption;

public class ClientPlainChannelInitializer
implements ChannelInitializer {
    private final boolean directBuffer;
    private final SocketOptions socketOptions;

    public ClientPlainChannelInitializer(SocketOptions socketOptions, boolean directBuffer) {
        this.socketOptions = socketOptions;
        this.directBuffer = directBuffer;
    }

    @Override
    public void initChannel(Channel channel) {
        channel.options().setOption(ChannelOption.SO_SNDBUF, 1024 * this.socketOptions.getBufferSize()).setOption(ChannelOption.SO_RCVBUF, 1024 * this.socketOptions.getBufferSize()).setOption(ChannelOption.SO_REUSEADDR, this.socketOptions.isReuseAddress()).setOption(ChannelOption.SO_KEEPALIVE, this.socketOptions.isKeepAlive()).setOption(ChannelOption.SO_LINGER, this.socketOptions.getLingerSeconds()).setOption(ChannelOption.SO_TIMEOUT, 0).setOption(ChannelOption.TCP_NODELAY, this.socketOptions.isTcpNoDelay()).setOption(ChannelOption.DIRECT_BUF, this.directBuffer);
        TcpClientConnection connection = (TcpClientConnection)channel.attributeMap().get(TcpClientConnection.class);
        ClientMessageDecoder decoder = new ClientMessageDecoder(connection, connection::handleClientMessage, null);
        channel.inboundPipeline().addLast(decoder);
        channel.outboundPipeline().addLast(new ClientMessageEncoder());
        channel.outboundPipeline().addLast(new ClientProtocolEncoder());
    }
}

