/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.multimap;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MultiMapPutAllCodec;
import com.hazelcast.client.impl.protocol.task.AbstractPartitionMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.map.impl.DataCollection;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.multimap.impl.operations.PutAllOperation;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MultiMapPutAllMessageTask
extends AbstractPartitionMessageTask<MultiMapPutAllCodec.RequestParameters> {
    public MultiMapPutAllMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Operation prepareOperation() {
        MapEntries mapEntries = new MapEntries();
        for (Map.Entry<Data, List<Data>> e : ((MultiMapPutAllCodec.RequestParameters)this.parameters).entries) {
            mapEntries.add(e.getKey(), (Data)this.serializationService.toData(new DataCollection((Collection<Data>)e.getValue())));
        }
        return new PutAllOperation(((MultiMapPutAllCodec.RequestParameters)this.parameters).name, mapEntries);
    }

    @Override
    protected MultiMapPutAllCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MultiMapPutAllCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MultiMapPutAllCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    public String getDistributedObjectName() {
        return ((MultiMapPutAllCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(((MultiMapPutAllCodec.RequestParameters)this.parameters).name, "put");
    }

    @Override
    public String getMethodName() {
        return "putAll";
    }

    @Override
    public Object[] getParameters() {
        Map map = MapUtil.createHashMap(((MultiMapPutAllCodec.RequestParameters)this.parameters).entries.size());
        for (Map.Entry<Data, List<Data>> entry : ((MultiMapPutAllCodec.RequestParameters)this.parameters).entries) {
            map.put(entry.getKey(), this.serializationService.toData(new DataCollection((Collection<Data>)entry.getValue())));
        }
        return new Object[]{map};
    }
}

