/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.fasterxml.jackson.jr.ob.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class POJODefinition {
    protected final Class<?> _type;
    protected final Prop[] _properties;
    protected final Set<String> _ignorableNames;
    public final Constructor<?> defaultCtor;
    public final Constructor<?> stringCtor;
    public final Constructor<?> longCtor;

    public POJODefinition(Class<?> clazz, Prop[] propArray, Constructor<?> constructor, Constructor<?> constructor2, Constructor<?> constructor3) {
        this._type = clazz;
        this._properties = propArray;
        this.defaultCtor = constructor;
        this.stringCtor = constructor2;
        this.longCtor = constructor3;
        this._ignorableNames = null;
    }

    protected POJODefinition(POJODefinition pOJODefinition, Prop[] propArray, Set<String> set) {
        this._type = pOJODefinition._type;
        this._properties = propArray;
        this.defaultCtor = pOJODefinition.defaultCtor;
        this.stringCtor = pOJODefinition.stringCtor;
        this.longCtor = pOJODefinition.longCtor;
        this._ignorableNames = set;
    }

    public POJODefinition withProperties(Collection<Prop> collection) {
        return new POJODefinition(this, collection.toArray(new Prop[0]), this._ignorableNames);
    }

    public POJODefinition withIgnorals(Set<String> set) {
        return new POJODefinition(this, this._properties, set);
    }

    public List<Prop> getProperties() {
        return Arrays.asList(this._properties);
    }

    @Deprecated
    public Prop[] properties() {
        return this._properties;
    }

    public Set<String> getIgnorableNames() {
        if (this._ignorableNames == null) {
            return Collections.emptySet();
        }
        return this._ignorableNames;
    }

    static final class PropBuilder {
        private final String _name;
        private Field _field;
        private Method _setter;
        private Method _getter;
        private Method _isGetter;

        public PropBuilder(String string) {
            this._name = string;
        }

        public Prop build() {
            return new Prop(this._name, this._field, this._setter, this._getter, this._isGetter, null);
        }

        public PropBuilder withField(Field field2) {
            this._field = field2;
            return this;
        }

        public PropBuilder withSetter(Method method) {
            this._setter = method;
            return this;
        }

        public PropBuilder withGetter(Method method) {
            this._getter = method;
            return this;
        }

        public PropBuilder withIsGetter(Method method) {
            this._isGetter = method;
            return this;
        }
    }

    public static final class Prop {
        public final String name;
        public final Field field;
        public final Method setter;
        public final Method getter;
        public final Method isGetter;
        private final Collection<String> aliases;

        public Prop(String string, Field field2, Method method, Method method2, Method method3, Collection<String> collection) {
            this.name = string;
            this.field = field2;
            this.setter = method;
            this.getter = method2;
            this.isGetter = method3;
            if (collection == null) {
                collection = Collections.emptyList();
            }
            this.aliases = collection;
        }

        public static PropBuilder builder(String string) {
            return new PropBuilder(string);
        }

        public boolean hasSetter() {
            return this.setter != null || this.field != null;
        }

        public boolean hasAliases() {
            return !this.aliases.isEmpty();
        }

        public Iterable<String> aliases() {
            return this.aliases;
        }
    }
}

