/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.membergroup;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.partition.membergroup.BackupSafeMemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.DefaultMemberGroup;
import com.hazelcast.internal.partition.membergroup.MemberGroupFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.partitiongroup.MemberGroup;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PlacementAwareMemberGroupFactory
extends BackupSafeMemberGroupFactory
implements MemberGroupFactory {
    @Override
    protected Set<MemberGroup> createInternalMemberGroups(Collection<? extends Member> allMembers) {
        Map<String, MemberGroup> groups = MapUtil.createHashMap(allMembers.size());
        for (Member member : allMembers) {
            String placementInfo = member.getAttribute("hazelcast.partition.group.placement");
            if (placementInfo == null) {
                throw new IllegalArgumentException("Not enough metadata information is provided. A group name indicating the placement group must be provided with PLACEMENT_AWARE partition group.");
            }
            MemberGroup group = (MemberGroup)groups.get(placementInfo);
            if (group == null) {
                group = new DefaultMemberGroup();
                groups.put(placementInfo, group);
            }
            group.addMember(member);
        }
        return new HashSet<MemberGroup>(groups.values());
    }
}

