/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Comparator;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SchemaWriter
implements CompactWriter {
    private final TreeMap<String, FieldDescriptor> fieldDefinitionMap = new TreeMap(Comparator.naturalOrder());
    private final String typeName;

    public SchemaWriter(String typeName) {
        this.typeName = typeName;
    }

    public Schema build() {
        return new Schema(this.typeName, this.fieldDefinitionMap);
    }

    public void addField(FieldDescriptor fieldDefinition) {
        this.fieldDefinitionMap.put(fieldDefinition.getFieldName(), fieldDefinition);
    }

    @Override
    public void writeInt32(@Nonnull String fieldName, int value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.INT32));
    }

    @Override
    public void writeInt64(@Nonnull String fieldName, long value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.INT64));
    }

    @Override
    public void writeString(@Nonnull String fieldName, String str) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.STRING));
    }

    @Override
    public void writeBoolean(@Nonnull String fieldName, boolean value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.BOOLEAN));
    }

    @Override
    public void writeInt8(@Nonnull String fieldName, byte value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.INT8));
    }

    @Override
    public void writeFloat64(@Nonnull String fieldName, double value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.FLOAT64));
    }

    @Override
    public void writeFloat32(@Nonnull String fieldName, float value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.FLOAT32));
    }

    @Override
    public void writeInt16(@Nonnull String fieldName, short value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.INT16));
    }

    public void writeCompact(@Nonnull String fieldName, @Nullable Object object) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.COMPACT));
    }

    @Override
    public void writeDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.DECIMAL));
    }

    @Override
    public void writeTime(@Nonnull String fieldName, @Nullable LocalTime value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.TIME));
    }

    @Override
    public void writeDate(@Nonnull String fieldName, @Nullable LocalDate value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.DATE));
    }

    @Override
    public void writeTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.TIMESTAMP));
    }

    @Override
    public void writeTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.TIMESTAMP_WITH_TIMEZONE));
    }

    @Override
    public void writeArrayOfInt8(@Nonnull String fieldName, @Nullable byte[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_INT8));
    }

    @Override
    public void writeArrayOfBoolean(@Nonnull String fieldName, @Nullable boolean[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_BOOLEAN));
    }

    @Override
    public void writeArrayOfInt32(@Nonnull String fieldName, @Nullable int[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_INT32));
    }

    @Override
    public void writeArrayOfInt64(@Nonnull String fieldName, @Nullable long[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_INT64));
    }

    @Override
    public void writeArrayOfFloat64(@Nonnull String fieldName, @Nullable double[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_FLOAT64));
    }

    @Override
    public void writeArrayOfFloat32(@Nonnull String fieldName, @Nullable float[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_FLOAT32));
    }

    @Override
    public void writeArrayOfInt16(@Nonnull String fieldName, @Nullable short[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_INT16));
    }

    @Override
    public void writeArrayOfString(@Nonnull String fieldName, @Nullable String[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_STRING));
    }

    @Override
    public void writeArrayOfDecimal(@Nonnull String fieldName, @Nullable BigDecimal[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_DECIMAL));
    }

    @Override
    public void writeArrayOfTime(@Nonnull String fieldName, @Nullable LocalTime[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_TIME));
    }

    @Override
    public void writeArrayOfDate(@Nonnull String fieldName, @Nullable LocalDate[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_DATE));
    }

    @Override
    public void writeArrayOfTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_TIMESTAMP));
    }

    @Override
    public void writeArrayOfTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE));
    }

    public void writeArrayOfCompact(@Nonnull String fieldName, @Nullable Object[] values) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_COMPACT));
    }

    @Override
    public void writeNullableInt8(@Nonnull String fieldName, @Nullable Byte value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.NULLABLE_INT8));
    }

    @Override
    public void writeNullableBoolean(@Nonnull String fieldName, @Nullable Boolean value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.NULLABLE_BOOLEAN));
    }

    @Override
    public void writeNullableInt16(@Nonnull String fieldName, @Nullable Short value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.NULLABLE_INT16));
    }

    @Override
    public void writeNullableInt32(@Nonnull String fieldName, @Nullable Integer value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.NULLABLE_INT32));
    }

    @Override
    public void writeNullableInt64(@Nonnull String fieldName, @Nullable Long value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.NULLABLE_INT64));
    }

    @Override
    public void writeNullableFloat32(@Nonnull String fieldName, @Nullable Float value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.NULLABLE_FLOAT32));
    }

    @Override
    public void writeNullableFloat64(@Nonnull String fieldName, @Nullable Double value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.NULLABLE_FLOAT64));
    }

    @Override
    public void writeArrayOfNullableInt8(@Nonnull String fieldName, @Nullable Byte[] value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT8));
    }

    @Override
    public void writeArrayOfNullableBoolean(@Nonnull String fieldName, @Nullable Boolean[] value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN));
    }

    @Override
    public void writeArrayOfNullableInt16(@Nonnull String fieldName, @Nullable Short[] value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT16));
    }

    @Override
    public void writeArrayOfNullableInt32(@Nonnull String fieldName, @Nullable Integer[] value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT32));
    }

    @Override
    public void writeArrayOfNullableInt64(@Nonnull String fieldName, @Nullable Long[] value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT64));
    }

    @Override
    public void writeArrayOfNullableFloat32(@Nonnull String fieldName, @Nullable Float[] value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT32));
    }

    @Override
    public void writeArrayOfNullableFloat64(@Nonnull String fieldName, @Nullable Double[] value) {
        this.addField(new FieldDescriptor(fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT64));
    }
}

