/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.MapUtil;
import java.util.Collections;
import java.util.Map;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static int getInt(JsonObject object, String field2) {
        JsonValue value = object.get(field2);
        JsonUtil.throwExceptionIfNull(value, field2);
        return value.asInt();
    }

    public static int getInt(JsonObject object, String field2, int defaultValue) {
        JsonValue value = object.get(field2);
        if (value == null || value.isNull()) {
            return defaultValue;
        }
        return value.asInt();
    }

    public static long getLong(JsonObject object, String field2) {
        JsonValue value = object.get(field2);
        JsonUtil.throwExceptionIfNull(value, field2);
        return value.asLong();
    }

    public static long getLong(JsonObject object, String field2, long defaultValue) {
        JsonValue value = object.get(field2);
        if (value == null || value.isNull()) {
            return defaultValue;
        }
        return value.asLong();
    }

    public static double getDouble(JsonObject object, String field2) {
        JsonValue value = object.get(field2);
        JsonUtil.throwExceptionIfNull(value, field2);
        return value.asDouble();
    }

    public static double getDouble(JsonObject object, String field2, double defaultValue) {
        JsonValue value = object.get(field2);
        if (value == null || value.isNull()) {
            return defaultValue;
        }
        return value.asDouble();
    }

    public static float getFloat(JsonObject object, String field2) {
        JsonValue value = object.get(field2);
        JsonUtil.throwExceptionIfNull(value, field2);
        return value.asFloat();
    }

    public static float getFloat(JsonObject object, String field2, float defaultValue) {
        JsonValue value = object.get(field2);
        if (value == null || value.isNull()) {
            return defaultValue;
        }
        return value.asFloat();
    }

    public static String getString(JsonObject object, String field2) {
        JsonValue value = object.get(field2);
        JsonUtil.throwExceptionIfNull(value, field2);
        return value.asString();
    }

    public static String getString(JsonObject object, String field2, String defaultValue) {
        JsonValue value = object.get(field2);
        if (value == null || value.isNull()) {
            return defaultValue;
        }
        return value.asString();
    }

    public static boolean getBoolean(JsonObject object, String field2) {
        JsonValue value = object.get(field2);
        JsonUtil.throwExceptionIfNull(value, field2);
        return value.asBoolean();
    }

    public static boolean getBoolean(JsonObject object, String field2, boolean defaultValue) {
        JsonValue value = object.get(field2);
        if (value == null || value.isNull()) {
            return defaultValue;
        }
        return value.asBoolean();
    }

    public static JsonArray getArray(JsonObject object, String field2) {
        JsonValue value = object.get(field2);
        JsonUtil.throwExceptionIfNull(value, field2);
        return value.asArray();
    }

    public static JsonArray getArray(JsonObject object, String field2, JsonArray defaultValue) {
        JsonValue value = object.get(field2);
        if (value == null || value.isNull()) {
            return defaultValue;
        }
        return value.asArray();
    }

    public static JsonObject getObject(JsonObject object, String field2) {
        JsonValue value = object.get(field2);
        JsonUtil.throwExceptionIfNull(value, field2);
        return value.asObject();
    }

    public static JsonObject getObject(JsonObject object, String field2, JsonObject defaultValue) {
        JsonValue value = object.get(field2);
        if (value == null || value.isNull()) {
            return defaultValue;
        }
        return value.asObject();
    }

    public static Map<String, Comparable> fromJsonObject(JsonObject object) {
        if (object == null || object.isNull() || object.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Comparable> map = MapUtil.createHashMap(object.size());
        for (String propertyName : object.names()) {
            map.put(propertyName, (Comparable)((Object)object.get(propertyName).asString()));
        }
        return map;
    }

    public static JsonObject toJsonObject(Map<String, ?> map) {
        JsonObject properties = new JsonObject();
        for (Map.Entry<String, ?> property : map.entrySet()) {
            properties.add(property.getKey(), Json.value(property.getValue().toString()));
        }
        return properties;
    }

    private static void throwExceptionIfNull(JsonValue value, String field2) {
        if (value == null) {
            throw new IllegalArgumentException("No field found: " + field2);
        }
    }
}

