/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.atomiclong.AtomicLongService;
import com.hazelcast.cp.internal.datastructures.atomicref.AtomicRefService;
import com.hazelcast.cp.internal.datastructures.countdownlatch.CountDownLatchService;
import com.hazelcast.cp.internal.datastructures.lock.LockService;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.util.function.BiConsumer;

public class CPSubsystemInfoCollector
implements MetricsCollector {
    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer2) {
        int cpMemberCount = node.getNodeEngine().getConfig().getCPSubsystemConfig().getCPMemberCount();
        boolean cpSubsystemEnabled = cpMemberCount != 0;
        metricsConsumer2.accept(PhoneHomeMetrics.CP_SUBSYSTEM_ENABLED, String.valueOf(cpSubsystemEnabled));
        if (cpSubsystemEnabled) {
            metricsConsumer2.accept(PhoneHomeMetrics.CP_MEMBERS_COUNT, String.valueOf(cpMemberCount));
            RaftService raftService = (RaftService)node.getNodeEngine().getService("hz:core:raft");
            int groupsCount = raftService.getMetadataGroupManager().getGroupIds().size();
            metricsConsumer2.accept(PhoneHomeMetrics.CP_GROUPS_COUNT, String.valueOf(groupsCount));
            SemaphoreService semaphoreService = (SemaphoreService)node.getNodeEngine().getService("hz:raft:semaphoreService");
            int semaphoresCount = semaphoreService.getTotalResourcesCount();
            metricsConsumer2.accept(PhoneHomeMetrics.CP_SEMAPHORES_COUNT, String.valueOf(semaphoresCount));
            CountDownLatchService clService = (CountDownLatchService)node.getNodeEngine().getService("hz:raft:countDownLatchService");
            int clCount = clService.getTotalResourcesCount();
            metricsConsumer2.accept(PhoneHomeMetrics.CP_COUNTDOWN_LATCHES_COUNT, String.valueOf(clCount));
            LockService lockService = (LockService)node.getNodeEngine().getService("hz:raft:lockService");
            int locksCount = lockService.getTotalResourcesCount();
            metricsConsumer2.accept(PhoneHomeMetrics.CP_FENCED_LOCKS_COUNT, String.valueOf(locksCount));
            AtomicLongService atomicLongService = (AtomicLongService)node.getNodeEngine().getService("hz:raft:atomicLongService");
            int atomicLongsCount = atomicLongService.getAtomicValuesCount();
            metricsConsumer2.accept(PhoneHomeMetrics.CP_ATOMIC_LONGS_COUNT, String.valueOf(atomicLongsCount));
            AtomicRefService atomicRefService = (AtomicRefService)node.getNodeEngine().getService("hz:raft:atomicRefService");
            int atomicRefsCount = atomicRefService.getAtomicValuesCount();
            metricsConsumer2.accept(PhoneHomeMetrics.CP_ATOMIC_REFS_COUNT, String.valueOf(atomicRefsCount));
        }
    }
}

