/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.pipeline.Pipeline;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface JetService {
    @Nonnull
    public JetConfig getConfig();

    @Nonnull
    default public Job newJob(@Nonnull DAG dag) {
        return this.newJob(dag, new JobConfig());
    }

    @Nonnull
    default public Job newJob(@Nonnull Pipeline pipeline) {
        return this.newJob(pipeline, new JobConfig());
    }

    @Nonnull
    public Job newJob(@Nonnull DAG var1, @Nonnull JobConfig var2);

    @Nonnull
    public Job newJob(@Nonnull Pipeline var1, @Nonnull JobConfig var2);

    @Nonnull
    public Job newJobIfAbsent(@Nonnull DAG var1, @Nonnull JobConfig var2);

    @Nonnull
    public Job newJobIfAbsent(@Nonnull Pipeline var1, @Nonnull JobConfig var2);

    @Nonnull
    default public Job newLightJob(@Nonnull Pipeline p) {
        return this.newLightJob(p, new JobConfig());
    }

    public Job newLightJob(@Nonnull Pipeline var1, @Nonnull JobConfig var2);

    @Nonnull
    default public Job newLightJob(@Nonnull DAG dag) {
        return this.newLightJob(dag, new JobConfig());
    }

    public Job newLightJob(@Nonnull DAG var1, @Nonnull JobConfig var2);

    @Nonnull
    public List<Job> getJobs();

    @Nullable
    public Job getJob(long var1);

    @Nonnull
    public List<Job> getJobs(@Nonnull String var1);

    @Nullable
    default public Job getJob(@Nonnull String name) {
        return this.getJobs(name).stream().findFirst().orElse(null);
    }

    @Nullable
    public JobStateSnapshot getJobStateSnapshot(@Nonnull String var1);

    @Nonnull
    public Collection<JobStateSnapshot> getJobStateSnapshots();

    @Nonnull
    public <T> Observable<T> getObservable(@Nonnull String var1);

    @Nonnull
    default public <T> Observable<T> newObservable() {
        return this.getObservable(UuidUtil.newUnsecureUuidString());
    }

    @Nonnull
    public Collection<Observable<?>> getObservables();
}

