/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.connector.HazelcastWriters;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public abstract class AsyncHazelcastWriterP
implements Processor {
    protected static final int MAX_PARALLEL_ASYNC_OPS_DEFAULT = 1000;
    private final ILogger logger = Logger.getLogger(AsyncHazelcastWriterP.class);
    private final int maxParallelAsyncOps;
    private final AtomicInteger numConcurrentOps = new AtomicInteger();
    private final AtomicReference<Throwable> firstError = new AtomicReference();
    private final HazelcastInstance instance;
    private final boolean isLocal;
    private final BiConsumer callback = ExceptionUtil.withTryCatch(this.logger, (response, t) -> {
        this.numConcurrentOps.decrementAndGet();
        if (t != null) {
            this.firstError.compareAndSet((Throwable)null, (Throwable)t);
        }
    });

    AsyncHazelcastWriterP(@Nonnull HazelcastInstance instance, int maxParallelAsyncOps) {
        this.instance = Objects.requireNonNull(instance, "instance");
        this.maxParallelAsyncOps = maxParallelAsyncOps;
        this.isLocal = ImdgUtil.isMemberInstance(instance);
    }

    @Override
    public final boolean tryProcess() {
        this.flush();
        return true;
    }

    @Override
    public final void process(int ordinal, @Nonnull Inbox inbox) {
        this.checkError();
        try {
            this.processInternal(inbox);
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw HazelcastWriters.handleInstanceNotActive(e, this.isLocal());
        }
    }

    @Override
    public final boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    @Override
    public boolean saveToSnapshot() {
        return this.flush() && this.asyncCallsDone();
    }

    @Override
    public final boolean complete() {
        return this.flush() && this.asyncCallsDone();
    }

    private boolean flush() {
        this.checkError();
        try {
            return this.flushInternal();
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw HazelcastWriters.handleInstanceNotActive(e, this.isLocal());
        }
    }

    @CheckReturnValue
    protected boolean flushInternal() {
        return true;
    }

    protected abstract void processInternal(Inbox var1);

    protected final void setCallback(CompletionStage stage) {
        stage.whenCompleteAsync(this.callback);
    }

    @CheckReturnValue
    protected final boolean tryAcquirePermit() {
        return Util.tryIncrement(this.numConcurrentOps, 1, this.maxParallelAsyncOps);
    }

    @CheckReturnValue
    protected final int tryAcquirePermits(int desiredNumber) {
        int next;
        int prev;
        do {
            if ((next = Math.min((prev = this.numConcurrentOps.get()) + desiredNumber, this.maxParallelAsyncOps)) != prev) continue;
            return 0;
        } while (!this.numConcurrentOps.compareAndSet(prev, next));
        return next - prev;
    }

    protected final HazelcastInstance instance() {
        return this.instance;
    }

    protected final boolean isLocal() {
        return this.isLocal;
    }

    private void checkError() {
        Throwable t = this.firstError.get();
        if (t instanceof HazelcastInstanceNotActiveException) {
            throw HazelcastWriters.handleInstanceNotActive((HazelcastInstanceNotActiveException)t, this.isLocal());
        }
        if (t != null) {
            throw ExceptionUtil.sneakyThrow(t);
        }
    }

    private boolean asyncCallsDone() {
        boolean allWritten = this.numConcurrentOps.get() == 0;
        this.checkError();
        return allWritten;
    }
}

