/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.wan.WanMapEntryView;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanEventType;
import com.hazelcast.wan.impl.InternalWanEvent;
import com.hazelcast.wan.impl.WanDataSerializerHook;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WanMapAddOrUpdateEvent
implements InternalWanEvent<EntryView<Object, Object>>,
IdentifiedDataSerializable {
    private String mapName;
    private SplitBrainMergePolicy mergePolicy;
    private WanMapEntryView<Object, Object> entryView;

    public WanMapAddOrUpdateEvent() {
    }

    public WanMapAddOrUpdateEvent(@Nonnull String mapName, @Nonnull SplitBrainMergePolicy mergePolicy, @Nonnull WanMapEntryView<Object, Object> entryView) {
        this.mergePolicy = mergePolicy;
        this.mapName = mapName;
        this.entryView = entryView;
    }

    public SplitBrainMergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public void setMergePolicy(SplitBrainMergePolicy mergePolicy) {
        this.mergePolicy = mergePolicy;
    }

    public WanMapEntryView<Object, Object> getEntryView() {
        return this.entryView;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.mapName);
        out.writeObject(this.mergePolicy);
        out.writeObject(this.entryView);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readString();
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
        this.entryView = (WanMapEntryView)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void incrementEventCount(@Nonnull WanEventCounters counters) {
        counters.incrementUpdate(this.mapName);
    }

    @Override
    @Nonnull
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    @Nonnull
    public Data getKey() {
        return this.entryView.getDataKey();
    }

    @Override
    @Nonnull
    public Set<String> getClusterNames() {
        return Collections.emptySet();
    }

    @Override
    public int getBackupCount() {
        return 0;
    }

    @Override
    public long getCreationTime() {
        return 0L;
    }

    @Override
    @Nonnull
    public String getObjectName() {
        return this.mapName;
    }

    @Override
    @Nonnull
    public WanEventType getEventType() {
        return WanEventType.ADD_OR_UPDATE;
    }

    @Override
    @Nullable
    public EntryView<Object, Object> getEventObject() {
        return this.entryView;
    }
}

