/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.BitmapIndexStore;
import com.hazelcast.query.impl.GlobalIndexPartitionTracker;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.OrderedIndexStore;
import com.hazelcast.query.impl.UnorderedIndexStore;
import com.hazelcast.query.impl.getters.Extractors;

public class IndexImpl
extends AbstractIndex {
    private final GlobalIndexPartitionTracker partitionTracker;

    public IndexImpl(IndexConfig config, InternalSerializationService ss, Extractors extractors, IndexCopyBehavior copyBehavior, PerIndexStats stats, int partitionCount) {
        super(config, ss, extractors, copyBehavior, stats);
        this.partitionTracker = new GlobalIndexPartitionTracker(partitionCount);
    }

    @Override
    protected IndexStore createIndexStore(IndexConfig config, PerIndexStats stats) {
        switch (config.getType()) {
            case SORTED: {
                return new OrderedIndexStore(this.copyBehavior);
            }
            case HASH: {
                return new UnorderedIndexStore(this.copyBehavior);
            }
            case BITMAP: {
                return new BitmapIndexStore(config);
            }
        }
        throw new IllegalArgumentException("unexpected index type: " + (Object)((Object)config.getType()));
    }

    @Override
    public void clear() {
        super.clear();
        this.partitionTracker.clear();
    }

    @Override
    public boolean hasPartitionIndexed(int partitionId) {
        return this.partitionTracker.isIndexed(partitionId);
    }

    @Override
    public boolean allPartitionsIndexed(int ownedPartitionCount) {
        return ownedPartitionCount < 0 || this.partitionTracker.indexedCount() == ownedPartitionCount;
    }

    @Override
    public void beginPartitionUpdate() {
        this.partitionTracker.beginPartitionUpdate();
    }

    @Override
    public void markPartitionAsIndexed(int partitionId) {
        this.partitionTracker.partitionIndexed(partitionId);
    }

    @Override
    public void markPartitionAsUnindexed(int partitionId) {
        this.partitionTracker.partitionUnindexed(partitionId);
    }

    @Override
    public GlobalIndexPartitionTracker.PartitionStamp getPartitionStamp() {
        return this.partitionTracker.getPartitionStamp();
    }

    @Override
    public boolean validatePartitionStamp(long stamp) {
        return this.partitionTracker.validatePartitionStamp(stamp);
    }

    @Override
    public String toString() {
        return "IndexImpl{partitionTracker=" + this.partitionTracker + "} " + super.toString();
    }
}

