/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.optimizer;

import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class PlanCheckContext {
    private final Set<PlanObjectKey> objectKeys;
    private final Map<UUID, PartitionIdSet> partitions;

    public PlanCheckContext(Set<PlanObjectKey> objectKeys, Map<UUID, PartitionIdSet> partitions) {
        this.objectKeys = objectKeys;
        this.partitions = partitions;
    }

    public boolean isValid(Set<PlanObjectKey> expectedObjectVersions) {
        return this.objectKeys.containsAll(expectedObjectVersions);
    }

    public boolean isValid(Set<PlanObjectKey> expectedObjectVersions, Map<UUID, PartitionIdSet> expectedPartitions) {
        if (!this.objectKeys.containsAll(expectedObjectVersions)) {
            return false;
        }
        return this.partitions.equals(expectedPartitions);
    }
}

