/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.diagnostics.HealthMonitor;
import com.hazelcast.internal.diagnostics.HealthMonitorLevel;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.metrics.DoubleGauge;
import com.hazelcast.internal.metrics.LongGauge;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;

public class SeaTunnelHealthMonitor {
    private static final String[] UNITS = new String[]{"", "K", "M", "G", "T", "P", "E"};
    private static final double PERCENTAGE_MULTIPLIER = 100.0;
    private static final double THRESHOLD_PERCENTAGE_INVOCATIONS = 70.0;
    private static final double THRESHOLD_INVOCATIONS = 1000.0;
    private final ILogger logger;
    private final Node node;
    private final HealthMonitorLevel monitorLevel;
    private final int thresholdMemoryPercentage;
    private final int thresholdCPUPercentage;
    private final MetricsRegistry metricRegistry;
    private final SeaTunnelHealthMetrics healthMetrics;

    public SeaTunnelHealthMonitor(Node node) {
        this.node = node;
        this.logger = node.getLogger(HealthMonitor.class);
        this.metricRegistry = node.nodeEngine.getMetricsRegistry();
        this.monitorLevel = this.getHealthMonitorLevel();
        this.thresholdMemoryPercentage = node.getProperties().getInteger(ClusterProperty.HEALTH_MONITORING_THRESHOLD_MEMORY_PERCENTAGE);
        this.thresholdCPUPercentage = node.getProperties().getInteger(ClusterProperty.HEALTH_MONITORING_THRESHOLD_CPU_PERCENTAGE);
        this.healthMetrics = new SeaTunnelHealthMetrics();
    }

    private HealthMonitorLevel getHealthMonitorLevel() {
        String healthMonitorLevel = this.node.getProperties().getString(ClusterProperty.HEALTH_MONITORING_LEVEL);
        return HealthMonitorLevel.valueOf(healthMonitorLevel);
    }

    private static String percentageString(double p) {
        return String.format("%.2f%%", p);
    }

    private static String numberToUnit(long number) {
        for (int i = 6; i > 0; --i) {
            double step = Math.pow(1024.0, i);
            if (!((double)number > step)) continue;
            return String.format("%3.1f%s", (double)number / step, UNITS[i]);
        }
        return Long.toString(number);
    }

    public SeaTunnelHealthMetrics getHealthMetrics() {
        return this.healthMetrics;
    }

    public class SeaTunnelHealthMetrics {
        final LongGauge clientEndpointCount;
        final LongGauge clusterTimeDiff;
        final LongGauge executorAsyncQueueSize;
        final LongGauge executorClientQueueSize;
        final LongGauge executorQueryClientQueueSize;
        final LongGauge executorBlockingClientQueueSize;
        final LongGauge executorClusterQueueSize;
        final LongGauge executorScheduledQueueSize;
        final LongGauge executorSystemQueueSize;
        final LongGauge executorIoQueueSize;
        final LongGauge executorQueryQueueSize;
        final LongGauge executorMapLoadQueueSize;
        final LongGauge executorMapLoadAllKeysQueueSize;
        final LongGauge eventQueueSize;
        final LongGauge gcMinorCount;
        final LongGauge gcMinorTime;
        final LongGauge gcMajorCount;
        final LongGauge gcMajorTime;
        final LongGauge gcUnknownCount;
        final LongGauge gcUnknownTime;
        final LongGauge runtimeAvailableProcessors;
        final LongGauge runtimeMaxMemory;
        final LongGauge runtimeFreeMemory;
        final LongGauge runtimeTotalMemory;
        final LongGauge runtimeUsedMemory;
        final LongGauge threadPeakThreadCount;
        final LongGauge threadThreadCount;
        final DoubleGauge osProcessCpuLoad;
        final DoubleGauge osSystemLoadAverage;
        final DoubleGauge osSystemCpuLoad;
        final LongGauge osTotalPhysicalMemorySize;
        final LongGauge osFreePhysicalMemorySize;
        final LongGauge osTotalSwapSpaceSize;
        final LongGauge osFreeSwapSpaceSize;
        final LongGauge operationServiceExecutorQueueSize;
        final LongGauge operationServiceExecutorPriorityQueueSize;
        final LongGauge operationServiceResponseQueueSize;
        final LongGauge operationServiceRunningOperationsCount;
        final LongGauge operationServiceCompletedOperationsCount;
        final LongGauge operationServicePendingInvocationsCount;
        final DoubleGauge operationServicePendingInvocationsPercentage;
        final LongGauge proxyCount;
        final LongGauge tcpConnectionActiveCount;
        final LongGauge tcpConnectionCount;
        final LongGauge tcpConnectionClientCount;
        private final StringBuilder sb;
        private double memoryUsedOfTotalPercentage;
        private double memoryUsedOfMaxPercentage;

        public SeaTunnelHealthMetrics() {
            this.clientEndpointCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("client.endpoint.count");
            this.clusterTimeDiff = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("cluster.clock.clusterTimeDiff");
            this.executorAsyncQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:async.queueSize");
            this.executorClientQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:client.queueSize");
            this.executorQueryClientQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:client.query.queueSize");
            this.executorBlockingClientQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:client.blocking.queueSize");
            this.executorClusterQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:cluster.queueSize");
            this.executorScheduledQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:scheduled.queueSize");
            this.executorSystemQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:system.queueSize");
            this.executorIoQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:io.queueSize");
            this.executorQueryQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:query.queueSize");
            this.executorMapLoadQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:map-load.queueSize");
            this.executorMapLoadAllKeysQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:map-loadAllKeys.queueSize");
            this.eventQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("event.eventQueueSize");
            this.gcMinorCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("gc.minorCount");
            this.gcMinorTime = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("gc.minorTime");
            this.gcMajorCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("gc.majorCount");
            this.gcMajorTime = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("gc.majorTime");
            this.gcUnknownCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("gc.unknownCount");
            this.gcUnknownTime = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("gc.unknownTime");
            this.runtimeAvailableProcessors = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("runtime.availableProcessors");
            this.runtimeMaxMemory = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("runtime.maxMemory");
            this.runtimeFreeMemory = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("runtime.freeMemory");
            this.runtimeTotalMemory = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("runtime.totalMemory");
            this.runtimeUsedMemory = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("runtime.usedMemory");
            this.threadPeakThreadCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("thread.peakThreadCount");
            this.threadThreadCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("thread.threadCount");
            this.osProcessCpuLoad = SeaTunnelHealthMonitor.this.metricRegistry.newDoubleGauge("os.processCpuLoad");
            this.osSystemLoadAverage = SeaTunnelHealthMonitor.this.metricRegistry.newDoubleGauge("os.systemLoadAverage");
            this.osSystemCpuLoad = SeaTunnelHealthMonitor.this.metricRegistry.newDoubleGauge("os.systemCpuLoad");
            this.osTotalPhysicalMemorySize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("os.totalPhysicalMemorySize");
            this.osFreePhysicalMemorySize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("os.freePhysicalMemorySize");
            this.osTotalSwapSpaceSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("os.totalSwapSpaceSize");
            this.osFreeSwapSpaceSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("os.freeSwapSpaceSize");
            this.operationServiceExecutorQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("operation.queueSize");
            this.operationServiceExecutorPriorityQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("operation.priorityQueueSize");
            this.operationServiceResponseQueueSize = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("operation.responseQueueSize");
            this.operationServiceRunningOperationsCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("operation.runningCount");
            this.operationServiceCompletedOperationsCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("operation.completedCount");
            this.operationServicePendingInvocationsCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("operation.invocations.pending");
            this.operationServicePendingInvocationsPercentage = SeaTunnelHealthMonitor.this.metricRegistry.newDoubleGauge("operation.invocations.used");
            this.proxyCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("proxy.proxyCount");
            this.tcpConnectionActiveCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("tcp.connection.activeCount");
            this.tcpConnectionCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("tcp.connection.count");
            this.tcpConnectionClientCount = SeaTunnelHealthMonitor.this.metricRegistry.newLongGauge("tcp.connection.clientCount");
            this.sb = new StringBuilder();
        }

        public void update() {
            this.memoryUsedOfTotalPercentage = 100.0 * (double)this.runtimeUsedMemory.read() / (double)this.runtimeTotalMemory.read();
            this.memoryUsedOfMaxPercentage = 100.0 * (double)this.runtimeUsedMemory.read() / (double)this.runtimeMaxMemory.read();
        }

        boolean exceedsThreshold() {
            if (this.memoryUsedOfMaxPercentage > (double)SeaTunnelHealthMonitor.this.thresholdMemoryPercentage) {
                return true;
            }
            if (this.osProcessCpuLoad.read() > (double)SeaTunnelHealthMonitor.this.thresholdCPUPercentage) {
                return true;
            }
            if (this.osSystemCpuLoad.read() > (double)SeaTunnelHealthMonitor.this.thresholdCPUPercentage) {
                return true;
            }
            if (this.operationServicePendingInvocationsPercentage.read() > 70.0) {
                return true;
            }
            return (double)this.operationServicePendingInvocationsCount.read() > 1000.0;
        }

        public String render() {
            this.update();
            this.sb.setLength(0);
            this.renderProcessors();
            this.renderPhysicalMemory();
            this.renderSwap();
            this.renderHeap();
            this.renderNativeMemory();
            this.renderGc();
            this.renderLoad();
            this.renderThread();
            this.renderCluster();
            this.renderEvents();
            this.renderExecutors();
            this.renderOperationService();
            this.renderProxy();
            this.renderClient();
            this.renderConnection();
            return this.sb.toString();
        }

        private void renderConnection() {
            this.sb.append("connection.active.count=").append(this.tcpConnectionActiveCount.read()).append(", ");
            this.sb.append("client.connection.count=").append(this.tcpConnectionClientCount.read()).append(", ");
            this.sb.append("connection.count=").append(this.tcpConnectionCount.read());
        }

        private void renderClient() {
            this.sb.append("clientEndpoint.count=").append(this.clientEndpointCount.read()).append(", ");
        }

        private void renderProxy() {
            this.sb.append("proxy.count=").append(this.proxyCount.read()).append(", ");
        }

        private void renderLoad() {
            this.sb.append("load.process").append('=').append(String.format("%.2f", this.osProcessCpuLoad.read())).append("%, ");
            this.sb.append("load.system").append('=').append(String.format("%.2f", this.osSystemCpuLoad.read())).append("%, ");
            double value = this.osSystemLoadAverage.read();
            if (value < 0.0) {
                this.sb.append("load.systemAverage").append("=n/a ");
            } else {
                this.sb.append("load.systemAverage").append('=').append(String.format("%.2f", this.osSystemLoadAverage.read())).append(", ");
            }
        }

        private void renderProcessors() {
            this.sb.append("processors=").append(this.runtimeAvailableProcessors.read()).append(", ");
        }

        private void renderPhysicalMemory() {
            this.sb.append("physical.memory.total=").append(SeaTunnelHealthMonitor.numberToUnit(this.osTotalPhysicalMemorySize.read())).append(", ");
            this.sb.append("physical.memory.free=").append(SeaTunnelHealthMonitor.numberToUnit(this.osFreePhysicalMemorySize.read())).append(", ");
        }

        private void renderSwap() {
            this.sb.append("swap.space.total=").append(SeaTunnelHealthMonitor.numberToUnit(this.osTotalSwapSpaceSize.read())).append(", ");
            this.sb.append("swap.space.free=").append(SeaTunnelHealthMonitor.numberToUnit(this.osFreeSwapSpaceSize.read())).append(", ");
        }

        private void renderHeap() {
            this.sb.append("heap.memory.used=").append(SeaTunnelHealthMonitor.numberToUnit(this.runtimeUsedMemory.read())).append(", ");
            this.sb.append("heap.memory.free=").append(SeaTunnelHealthMonitor.numberToUnit(this.runtimeFreeMemory.read())).append(", ");
            this.sb.append("heap.memory.total=").append(SeaTunnelHealthMonitor.numberToUnit(this.runtimeTotalMemory.read())).append(", ");
            this.sb.append("heap.memory.max=").append(SeaTunnelHealthMonitor.numberToUnit(this.runtimeMaxMemory.read())).append(", ");
            this.sb.append("heap.memory.used/total=").append(SeaTunnelHealthMonitor.percentageString(this.memoryUsedOfTotalPercentage)).append(", ");
            this.sb.append("heap.memory.used/max=").append(SeaTunnelHealthMonitor.percentageString(this.memoryUsedOfMaxPercentage)).append(", ");
        }

        private void renderEvents() {
            this.sb.append("event.q.size=").append(this.eventQueueSize.read()).append(", ");
        }

        private void renderCluster() {
            this.sb.append("cluster.timeDiff=").append(this.clusterTimeDiff.read()).append(", ");
        }

        private void renderThread() {
            this.sb.append("thread.count=").append(this.threadThreadCount.read()).append(", ");
            this.sb.append("thread.peakCount=").append(this.threadPeakThreadCount.read()).append(", ");
        }

        private void renderGc() {
            this.sb.append("minor.gc.count=").append(this.gcMinorCount.read()).append(", ");
            this.sb.append("minor.gc.time=").append(this.gcMinorTime.read()).append("ms, ");
            this.sb.append("major.gc.count=").append(this.gcMajorCount.read()).append(", ");
            this.sb.append("major.gc.time=").append(this.gcMajorTime.read()).append("ms, ");
            if (this.gcUnknownCount.read() > 0L) {
                this.sb.append("unknown.gc.count=").append(this.gcUnknownCount.read()).append(", ");
                this.sb.append("unknown.gc.time=").append(this.gcUnknownTime.read()).append("ms, ");
            }
        }

        private void renderNativeMemory() {
            MemoryStats memoryStats = SeaTunnelHealthMonitor.this.node.getNodeExtension().getMemoryStats();
            if (memoryStats.getMaxNative() <= 0L) {
                return;
            }
            long maxNative = memoryStats.getMaxNative();
            long usedNative = memoryStats.getUsedNative();
            long usedMeta = memoryStats.getUsedMetadata();
            this.sb.append("native.memory.used=").append(SeaTunnelHealthMonitor.numberToUnit(usedNative)).append(", ");
            this.sb.append("native.memory.free=").append(SeaTunnelHealthMonitor.numberToUnit(memoryStats.getFreeNative())).append(", ");
            this.sb.append("native.memory.total=").append(SeaTunnelHealthMonitor.numberToUnit(memoryStats.getCommittedNative())).append(", ");
            this.sb.append("native.memory.max=").append(SeaTunnelHealthMonitor.numberToUnit(maxNative)).append(", ");
            this.sb.append("native.meta.memory.used=").append(SeaTunnelHealthMonitor.numberToUnit(usedMeta)).append(", ");
            this.sb.append("native.meta.memory.free=").append(SeaTunnelHealthMonitor.numberToUnit(maxNative - usedMeta)).append(", ");
            this.sb.append("native.meta.memory.percentage=").append(SeaTunnelHealthMonitor.percentageString(100.0 * (double)usedMeta / (double)maxNative)).append(", ");
        }

        private void renderExecutors() {
            this.sb.append("executor.q.async.size=").append(this.executorAsyncQueueSize.read()).append(", ");
            this.sb.append("executor.q.client.size=").append(this.executorClientQueueSize.read()).append(", ");
            this.sb.append("executor.q.client.query.size=").append(this.executorQueryClientQueueSize.read()).append(", ");
            this.sb.append("executor.q.client.blocking.size=").append(this.executorBlockingClientQueueSize.read()).append(", ");
            this.sb.append("executor.q.query.size=").append(this.executorQueryQueueSize.read()).append(", ");
            this.sb.append("executor.q.scheduled.size=").append(this.executorScheduledQueueSize.read()).append(", ");
            this.sb.append("executor.q.io.size=").append(this.executorIoQueueSize.read()).append(", ");
            this.sb.append("executor.q.system.size=").append(this.executorSystemQueueSize.read()).append(", ");
            this.sb.append("executor.q.operations.size=").append(this.operationServiceExecutorQueueSize.read()).append(", ");
            this.sb.append("executor.q.priorityOperation.size=").append(this.operationServiceExecutorPriorityQueueSize.read()).append(", ");
            this.sb.append("operations.completed.count=").append(this.operationServiceCompletedOperationsCount.read()).append(", ");
            this.sb.append("executor.q.mapLoad.size=").append(this.executorMapLoadQueueSize.read()).append(", ");
            this.sb.append("executor.q.mapLoadAllKeys.size=").append(this.executorMapLoadAllKeysQueueSize.read()).append(", ");
            this.sb.append("executor.q.cluster.size=").append(this.executorClusterQueueSize.read()).append(", ");
        }

        private void renderOperationService() {
            this.sb.append("executor.q.response.size=").append(this.operationServiceResponseQueueSize.read()).append(", ");
            this.sb.append("operations.running.count=").append(this.operationServiceRunningOperationsCount.read()).append(", ");
            this.sb.append("operations.pending.invocations.percentage=").append(String.format("%.2f", this.operationServicePendingInvocationsPercentage.read())).append("%, ");
            this.sb.append("operations.pending.invocations.count=").append(this.operationServicePendingInvocationsCount.read()).append(", ");
        }
    }
}

