/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.service.jar;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageConfig;
import org.apache.seatunnel.engine.core.job.CommonPluginJar;
import org.apache.seatunnel.engine.core.job.ConnectorJar;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.core.job.ConnectorJarType;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.service.jar.AbstractConnectorJarStorageStrategy;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class IsolatedConnectorJarStorageStrategy
extends AbstractConnectorJarStorageStrategy {
    public IsolatedConnectorJarStorageStrategy(ConnectorJarStorageConfig connectorJarStorageConfig, SeaTunnelServer seaTunnelServer) {
        super(connectorJarStorageConfig, seaTunnelServer);
    }

    @Override
    public ConnectorJarIdentifier storageConnectorJarFile(long jobId, ConnectorJar connectorJar) {
        File storageFile = this.getStorageLocation(jobId, connectorJar);
        if (storageFile.exists()) {
            return ConnectorJarIdentifier.of(connectorJar, storageFile.toString());
        }
        Optional<Path> optional = this.storageConnectorJarFileInternal(connectorJar, storageFile);
        return optional.map(path -> ConnectorJarIdentifier.of(connectorJar, path.toString())).orElseGet(() -> ConnectorJarIdentifier.of(connectorJar, ""));
    }

    @Override
    public boolean checkConnectorJarExisted(long jobId, ConnectorJar connectorJar) {
        File storageFile = this.getStorageLocation(jobId, connectorJar);
        return storageFile.exists();
    }

    @Override
    public void cleanUpWhenJobFinished(long jobId, List<ConnectorJarIdentifier> connectorJarIdentifierList) {
        connectorJarIdentifierList.forEach(this::deleteConnectorJar);
    }

    @Override
    public void deleteConnectorJar(ConnectorJarIdentifier connectorJarIdentifier) {
        this.deleteConnectorJarInternal(new File(connectorJarIdentifier.getStoragePath()));
        this.deleteConnectorJarInExecutionNode(connectorJarIdentifier);
    }

    @Override
    public String getStorageLocationPath(long jobId, ConnectorJar connectorJar) {
        Preconditions.checkNotNull(jobId);
        if (connectorJar.getType() == ConnectorJarType.COMMON_PLUGIN_JAR) {
            CommonPluginJar commonPluginJar = (CommonPluginJar)connectorJar;
            return String.format("%s/%s/%s/%s", this.storageDir, jobId, "/plugins", commonPluginJar.getFileName());
        }
        return String.format("%s/%s/%s/%s", this.storageDir, "/connectors", jobId, connectorJar.getFileName());
    }
}

