/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.group;

import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.engine.server.execution.Task;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.group.AbstractTaskGroupWithIntermediateQueue;
import org.apache.seatunnel.engine.server.task.group.queue.AbstractIntermediateQueue;
import org.apache.seatunnel.engine.server.task.group.queue.IntermediateDisruptor;
import org.apache.seatunnel.engine.server.task.group.queue.disruptor.RecordEvent;
import org.apache.seatunnel.engine.server.task.group.queue.disruptor.RecordEventFactory;

public class TaskGroupWithIntermediateDisruptor
extends AbstractTaskGroupWithIntermediateQueue {
    public static final int RING_BUFFER_SIZE = 1024;
    private Map<Long, Disruptor<RecordEvent>> disruptor = null;

    public TaskGroupWithIntermediateDisruptor(TaskGroupLocation taskGroupLocation, String taskGroupName, Collection<Task> tasks) {
        super(taskGroupLocation, taskGroupName, tasks);
    }

    @Override
    public void init() {
        this.disruptor = new ConcurrentHashMap<Long, Disruptor<RecordEvent>>();
        this.getTasks().stream().filter(SeaTunnelTask.class::isInstance).map(s2 -> (SeaTunnelTask)s2).forEach(s2 -> s2.setTaskGroup(this));
    }

    @Override
    public AbstractIntermediateQueue<?> getQueueCache(long id) {
        RecordEventFactory eventFactory = new RecordEventFactory();
        Disruptor<RecordEvent> disruptor = new Disruptor<RecordEvent>(eventFactory, 1024, DaemonThreadFactory.INSTANCE, ProducerType.SINGLE, (WaitStrategy)new YieldingWaitStrategy());
        this.disruptor.putIfAbsent(id, disruptor);
        return new IntermediateDisruptor(this.disruptor.get(id));
    }
}

