/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.jet.impl.util.EnumerationUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

final class JarScanner {
    private JarScanner() {
    }

    static List<String> findClassFiles(JarFile file, String className) {
        String filename = className + ".class";
        return EnumerationUtil.stream(file.entries()).map(ZipEntry::getName).map(x$0 -> Paths.get(x$0, new String[0])).filter(JarScanner.byFilename(filename)).map(Path::toString).collect(Collectors.toList());
    }

    private static Predicate<Path> byFilename(String filename) {
        return path -> path.getFileName().toString().equals(filename);
    }
}

