/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.schema;

import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.schema.MemberSchemaService;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SendAllSchemasOperation
extends Operation
implements IdentifiedDataSerializable {
    private Collection<Schema> schemas;

    public SendAllSchemasOperation() {
    }

    public SendAllSchemasOperation(Collection<Schema> schemas) {
        this.schemas = schemas;
    }

    @Override
    public void run() {
        MemberSchemaService schemaService = (MemberSchemaService)this.getService();
        for (Schema schema : this.schemas) {
            schemaService.putIfAbsent(schema);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        int size = this.schemas.size();
        out.writeInt(size);
        for (Schema schema : this.schemas) {
            out.writeObject(schema);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.schemas = new ArrayList<Schema>(size);
        for (int i = 0; i < size; ++i) {
            Schema schema = (Schema)in.readObject();
            this.schemas.add(schema);
        }
    }

    @Override
    public String getServiceName() {
        return "schema-service";
    }

    @Override
    public int getFactoryId() {
        return SchemaDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }
}

