/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

class CoreSerializerHooks {
    CoreSerializerHooks() {
    }

    public static final class JetEventHook
    implements SerializerHook<JetEvent> {
        @Override
        public Class<JetEvent> getSerializationType() {
            return JetEvent.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<JetEvent>(){

                @Override
                public void write(ObjectDataOutput out, JetEvent object) throws IOException {
                    out.writeObject(object.payload());
                    out.writeLong(object.timestamp());
                }

                @Override
                public JetEvent read(ObjectDataInput in) throws IOException {
                    Object payload = in.readObject();
                    long timestamp = in.readLong();
                    return JetEvent.jetEvent(timestamp, payload);
                }

                @Override
                public int getTypeId() {
                    return -325;
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class WatermarkHook
    implements SerializerHook<Watermark> {
        @Override
        public Class<Watermark> getSerializationType() {
            return Watermark.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<Watermark>(){

                @Override
                public int getTypeId() {
                    return -316;
                }

                @Override
                public void write(ObjectDataOutput out, Watermark object) throws IOException {
                    out.writeLong(object.timestamp());
                }

                @Override
                public Watermark read(ObjectDataInput in) throws IOException {
                    return new Watermark(in.readLong());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }
}

