/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;

public final class TablePath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String schemaName;
    private final String tableName;

    public static TablePath of(String fullName) {
        String[] paths = fullName.split("\\.");
        if (paths.length == 2) {
            return TablePath.of(paths[0], paths[1]);
        }
        if (paths.length == 3) {
            return TablePath.of(paths[0], paths[1], paths[2]);
        }
        throw new IllegalArgumentException(String.format("Cannot get split '%s' to get databaseName and tableName", fullName));
    }

    public static TablePath of(String databaseName, String tableName) {
        return TablePath.of(databaseName, null, tableName);
    }

    public static TablePath of(String databaseName, String schemaName, String tableName) {
        return new TablePath(databaseName, schemaName, tableName);
    }

    public String getSchemaAndTableName() {
        return String.format("%s.%s", this.schemaName, this.tableName);
    }

    public String getFullName() {
        if (this.schemaName == null) {
            return String.format("%s.%s", this.databaseName, this.tableName);
        }
        return String.format("%s.%s.%s", this.databaseName, this.schemaName, this.tableName);
    }

    public String getFullNameWithQuoted() {
        return this.getFullNameWithQuoted("`");
    }

    public String getFullNameWithQuoted(String quote) {
        if (this.schemaName == null) {
            return String.format("%s%s%s.%s%s%s", quote, this.databaseName, quote, quote, this.tableName, quote);
        }
        return String.format("%s%s%s.%s%s%s.%s%s%s", quote, this.databaseName, quote, quote, this.schemaName, quote, quote, this.tableName, quote);
    }

    public String toString() {
        return this.getFullName();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TablePath)) {
            return false;
        }
        TablePath other = (TablePath)o;
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        return result;
    }

    public TablePath(String databaseName, String schemaName, String tableName) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }
}

