/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dynamicforms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.app.dynamicforms.AbstractFormOption;
import org.apache.seatunnel.app.dynamicforms.FormLocale;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.dynamicforms.FormStructureValidate;
import org.apache.seatunnel.app.dynamicforms.exception.FormStructureValidateException;

public class FormStructureBuilder {
    private String name;
    private List<AbstractFormOption> forms = new ArrayList<AbstractFormOption>();
    private FormLocale locales;
    private Map<String, Map<String, String>> apis;

    public FormStructureBuilder name(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        return this;
    }

    public FormStructureBuilder addFormOption(AbstractFormOption ... formOptions) {
        if (formOptions == null) {
            throw new NullPointerException("formOptions is marked non-null but is null");
        }
        for (AbstractFormOption formOption : formOptions) {
            this.forms.add(formOption);
        }
        return this;
    }

    public FormStructureBuilder withLocale(FormLocale locale) {
        this.locales = locale;
        return this;
    }

    public FormStructureBuilder addApi(@NonNull String apiName, @NonNull String url, @NonNull FormStructure.HttpMethod method) {
        if (apiName == null) {
            throw new NullPointerException("apiName is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (this.apis == null) {
            this.apis = new HashMap<String, Map<String, String>>();
        }
        this.apis.putIfAbsent(apiName, new HashMap());
        this.apis.get(apiName).put("url", url);
        this.apis.get(apiName).put("method", method.name().toLowerCase(Locale.ROOT));
        return this;
    }

    public FormStructure build() throws FormStructureValidateException {
        FormStructure formStructure = new FormStructure(this.name, this.forms, this.locales, this.apis);
        FormStructureValidate.validateFormStructure(formStructure);
        return formStructure;
    }
}

