/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dynamicforms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.app.dynamicforms.DynamicSelectOption;
import org.apache.seatunnel.app.dynamicforms.FormLocale;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.dynamicforms.exception.FormStructureValidateException;
import org.apache.seatunnel.app.dynamicforms.validate.AbstractValidate;
import org.apache.seatunnel.app.dynamicforms.validate.MutuallyExclusiveValidate;
import org.apache.seatunnel.app.dynamicforms.validate.UnionNonEmptyValidate;

public class FormStructureValidate {
    public static void validateFormStructure(@NonNull FormStructure formStructure) throws FormStructureValidateException {
        if (formStructure == null) {
            throw new NullPointerException("formStructure is marked non-null but is null");
        }
        List<String> apiErrorList = FormStructureValidate.validateApiOption(formStructure);
        List<String> localeErrorList = FormStructureValidate.validateLocaleOption(formStructure);
        List<String> showErrorList = FormStructureValidate.validateShow(formStructure);
        List<String> unionNonErrorList = FormStructureValidate.validateUnionNonEmpty(formStructure);
        List<String> exclusiveErrorList = FormStructureValidate.validateMutuallyExclusive(formStructure);
        apiErrorList.addAll(localeErrorList);
        apiErrorList.addAll(showErrorList);
        apiErrorList.addAll(unionNonErrorList);
        apiErrorList.addAll(exclusiveErrorList);
        if (apiErrorList.size() > 0) {
            throw new FormStructureValidateException(formStructure.getName(), apiErrorList);
        }
    }

    private static List<String> validateApiOption(@NonNull FormStructure formStructure) {
        if (formStructure == null) {
            throw new NullPointerException("formStructure is marked non-null but is null");
        }
        ArrayList<String> errorMessageList = new ArrayList<String>();
        Map<String, Map<String, String>> apis = formStructure.getApis();
        formStructure.getForms().forEach(formOption -> {
            if (formOption instanceof DynamicSelectOption) {
                String api = ((DynamicSelectOption)formOption).getApi();
                if (apis == null || !apis.keySet().contains(api)) {
                    errorMessageList.add(String.format("DynamicSelectOption[%s] used api[%s] can not found in FormStructure.apis", ((DynamicSelectOption)formOption).getLabel(), api));
                }
            }
        });
        return errorMessageList;
    }

    private static List<String> validateLocaleOption(@NonNull FormStructure formStructure) {
        if (formStructure == null) {
            throw new NullPointerException("formStructure is marked non-null but is null");
        }
        ArrayList<String> errorMessageList = new ArrayList<String>();
        FormLocale locales = formStructure.getLocales();
        formStructure.getForms().forEach(formOption -> {
            Object validate;
            if (formOption.getLabel().startsWith("i18n.")) {
                String labelName = formOption.getLabel().replace("i18n.", "");
                FormStructureValidate.validateOneI18nOption(locales, formOption.getLabel(), "label", labelName, errorMessageList);
            }
            if (formOption.getDescription().startsWith("i18n.")) {
                String description = formOption.getDescription().replace("i18n.", "");
                FormStructureValidate.validateOneI18nOption(locales, formOption.getLabel(), "description", description, errorMessageList);
            }
            if (formOption.getPlaceholder().startsWith("i18n.")) {
                String placeholder = formOption.getPlaceholder().replace("i18n.", "");
                FormStructureValidate.validateOneI18nOption(locales, formOption.getLabel(), "placeholder", placeholder, errorMessageList);
            }
            if ((validate = formOption.getValidate()) != null && ((AbstractValidate)validate).getMessage().startsWith("i18n.")) {
                String message = ((AbstractValidate)validate).getMessage().replace("i18n.", "");
                FormStructureValidate.validateOneI18nOption(locales, formOption.getLabel(), "validateMessage", message, errorMessageList);
            }
        });
        return errorMessageList;
    }

    private static void validateOneI18nOption(FormLocale locale, @NonNull String formOptionLabel, @NonNull String formOptionName, @NonNull String key, @NonNull List<String> errorMessageList) {
        if (formOptionLabel == null) {
            throw new NullPointerException("formOptionLabel is marked non-null but is null");
        }
        if (formOptionName == null) {
            throw new NullPointerException("formOptionName is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (errorMessageList == null) {
            throw new NullPointerException("errorMessageList is marked non-null but is null");
        }
        if (locale == null || !locale.getEnUS().containsKey(key)) {
            errorMessageList.add(String.format("FormOption[%s] used i18n %s[%s] can not found in FormStructure.locales en_US", formOptionLabel, formOptionName, key));
        }
        if (locale == null || !locale.getZhCN().containsKey(key)) {
            errorMessageList.add(String.format("FormOption[%s] used i18n %s[%s] can not found in FormStructure.locales zh_CN", formOptionLabel, formOptionName, key));
        }
    }

    private static List<String> validateShow(@NonNull FormStructure formStructure) {
        if (formStructure == null) {
            throw new NullPointerException("formStructure is marked non-null but is null");
        }
        ArrayList<String> errorMessageList = new ArrayList<String>();
        List allFields = formStructure.getForms().stream().map(formOption -> formOption.getField()).collect(Collectors.toList());
        formStructure.getForms().forEach(formOption -> {
            Map<String, Object> show = formOption.getShow();
            if (show == null) {
                return;
            }
            String field = show.get("field").toString();
            if (allFields == null || !allFields.contains(field)) {
                errorMessageList.add(String.format("FormOption[%s] used show field[%s] can not found in form options", formOption.getLabel(), field));
            }
        });
        return errorMessageList;
    }

    private static List<String> validateUnionNonEmpty(@NonNull FormStructure formStructure) {
        if (formStructure == null) {
            throw new NullPointerException("formStructure is marked non-null but is null");
        }
        ArrayList<String> errorMessageList = new ArrayList<String>();
        HashMap<String, List> unionMap = new HashMap<String, List>();
        formStructure.getForms().forEach(formOption -> {
            if (formOption.getValidate() != null && formOption.getValidate() instanceof UnionNonEmptyValidate) {
                unionMap.put(formOption.getField(), ((UnionNonEmptyValidate)formOption.getValidate()).getFields());
            }
        });
        unionMap.forEach((k, v) -> {
            if (v == null || !v.contains(k)) {
                errorMessageList.add(String.format("UnionNonEmptyValidate Option field[%s] must in validate union field list", k));
            }
            if (v != null) {
                v.forEach(field -> {
                    if (!unionMap.keySet().contains(field)) {
                        errorMessageList.add(String.format("UnionNonEmptyValidate Option field[%s] , validate union field[%s] can not found in form options", k, field));
                    }
                });
            }
        });
        return errorMessageList;
    }

    private static List<String> validateMutuallyExclusive(@NonNull FormStructure formStructure) {
        if (formStructure == null) {
            throw new NullPointerException("formStructure is marked non-null but is null");
        }
        ArrayList<String> errorMessageList = new ArrayList<String>();
        HashMap<String, List> exclusiveMap = new HashMap<String, List>();
        formStructure.getForms().forEach(formOption -> {
            if (formOption.getValidate() != null && formOption.getValidate() instanceof MutuallyExclusiveValidate) {
                exclusiveMap.put(formOption.getField(), ((MutuallyExclusiveValidate)formOption.getValidate()).getFields());
            }
        });
        exclusiveMap.forEach((k, v) -> {
            if (v == null || !v.contains(k)) {
                errorMessageList.add(String.format("MutuallyExclusiveValidate Option field[%s] must in validate field list", k));
            }
            if (v != null) {
                v.forEach(field -> {
                    if (!exclusiveMap.keySet().contains(field)) {
                        errorMessageList.add(String.format("MutuallyExclusiveValidate Option field[%s] , validate field[%s] can not found in form options", k, field));
                    }
                });
            }
        });
        return errorMessageList;
    }
}

