/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.server.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class CodeGenerateUtils {
    private static final long START_TIMESTAMP = 1609430400000L;
    private static final long LOW_DIGIT_BIT = 5L;
    private static final long MIDDLE_BIT = 2L;
    private static final long MAX_LOW_DIGIT = 31L;
    private static final long MIDDLE_LEFT = 5L;
    private static final long HIGH_DIGIT_LEFT = 7L;
    private final long machineHash;
    private long lowDigit = 0L;
    private long recordMillisecond = -1L;
    private static final long SYSTEM_TIMESTAMP = System.currentTimeMillis();
    private static final long SYSTEM_NANOTIME = System.nanoTime();
    private static final int I = 1000000;
    private static CodeGenerateUtils INSTANCE = null;

    private CodeGenerateUtils() throws CodeGenerateException {
        try {
            this.machineHash = Math.abs(Objects.hash(InetAddress.getLocalHost().getHostName())) % 4;
        }
        catch (UnknownHostException e) {
            throw new CodeGenerateException(e.getMessage());
        }
    }

    public static synchronized CodeGenerateUtils getInstance() throws CodeGenerateException {
        if (INSTANCE == null) {
            INSTANCE = new CodeGenerateUtils();
        }
        return INSTANCE;
    }

    public synchronized long genCode() throws CodeGenerateException {
        long nowtMillisecond = this.systemMillisecond();
        if (nowtMillisecond < this.recordMillisecond) {
            throw new CodeGenerateException("New code exception because time is set back.");
        }
        if (nowtMillisecond == this.recordMillisecond) {
            this.lowDigit = this.lowDigit + 1L & 0x1FL;
            if (this.lowDigit == 0L) {
                while (nowtMillisecond <= this.recordMillisecond) {
                    nowtMillisecond = this.systemMillisecond();
                }
            }
        } else {
            this.lowDigit = 0L;
        }
        this.recordMillisecond = nowtMillisecond;
        return nowtMillisecond - 1609430400000L << 7 | this.machineHash << 5 | this.lowDigit;
    }

    private long systemMillisecond() {
        return SYSTEM_TIMESTAMP + (System.nanoTime() - SYSTEM_NANOTIME) / 1000000L;
    }

    public static class CodeGenerateException
    extends RuntimeException {
        public CodeGenerateException(String message) {
            super(message);
        }
    }
}

