/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.ScriptParamStatusEnum;
import org.apache.seatunnel.app.dal.dao.IScriptParamDao;
import org.apache.seatunnel.app.dal.entity.ScriptParam;
import org.apache.seatunnel.app.dal.mapper.ScriptParamMapper;
import org.apache.seatunnel.app.domain.dto.script.UpdateScriptParamDto;
import org.springframework.stereotype.Repository;

@Repository
public class ScriptParamDaoImpl
implements IScriptParamDao {
    @Resource
    private ScriptParamMapper scriptParamMapper;

    @Override
    public List<ScriptParam> getParamsByScriptId(int id) {
        return this.scriptParamMapper.selectByScriptId(id);
    }

    @Override
    public void updateStatusByScriptId(int scriptId, int code) {
        this.scriptParamMapper.updateStatusByScriptId(scriptId, (byte)code);
    }

    @Override
    public void batchInsert(UpdateScriptParamDto dto) {
        Map<String, String> keyAndValue = dto.getParams();
        ArrayList scriptParams = Lists.newArrayListWithCapacity((int)keyAndValue.size());
        keyAndValue.forEach((k, v) -> {
            ScriptParam scriptParam = new ScriptParam();
            scriptParam.setStatus((byte)ScriptParamStatusEnum.NORMAL.getCode());
            scriptParam.setKey((String)k);
            scriptParam.setValue((String)v);
            scriptParam.setScriptId(dto.getScriptId());
            scriptParams.add(scriptParam);
        });
        this.scriptParamMapper.batchInsert(scriptParams);
    }
}

