/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.interceptor;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.dal.dao.IUserDao;
import org.apache.seatunnel.app.dal.entity.User;
import org.apache.seatunnel.app.dal.entity.UserLoginLog;
import org.apache.seatunnel.app.security.JwtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthenticationInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationInterceptor.class);
    @Resource
    private IUserDao userDaoImpl;
    @Resource
    private JwtUtils jwtUtils;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (request.getMethod().equals("OPTIONS")) {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Headers", "*");
            response.setHeader("Access-Control-Allow-Methods", "*");
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setHeader("Access-Control-Max-Age", "3600");
            return true;
        }
        long currentTimestamp = System.currentTimeMillis();
        String token = request.getHeader("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            log.info("user does not exist");
            response.setStatus(401);
            return false;
        }
        Map<String, Object> map = this.jwtUtils.parseToken(token);
        Integer userId = (Integer)map.get("id");
        if (Objects.isNull(userId)) {
            log.info("userId does not exist");
            response.setStatus(401);
            return false;
        }
        UserLoginLog userLoginLog = this.userDaoImpl.getLastLoginLog(userId);
        if (Objects.isNull(userLoginLog) || !userLoginLog.getTokenStatus().booleanValue()) {
            log.info("userLoginLog does not exist");
            response.setStatus(401);
            return false;
        }
        Integer expireDate = (Integer)map.get("exp");
        if (Objects.isNull(expireDate) || currentTimestamp - (long)expireDate.intValue() * 1000L > 0L) {
            log.info("user token has expired");
            response.setStatus(401);
            return false;
        }
        map.forEach((arg_0, arg_1) -> ((HttpServletRequest)request).setAttribute(arg_0, arg_1));
        User user = new User();
        user.setUsername((String)map.get("name"));
        user.setId((Integer)map.get("id"));
        request.setAttribute("session.user", (Object)user);
        request.setAttribute("userId", (Object)userId);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

