/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.AbstractDataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.app.utils.JdbcUtils;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;

@AutoService(value={DataSourceConfigSwitcher.class})
public class ClickhouseDataSourceConfigSwitcher
extends AbstractDataSourceConfigSwitcher {
    private static final String HOST = "host";
    private static final String URL = "url";
    private static final String SQL = "sql";
    private static final String DATABASE = "database";
    private static final String TABLE = "table";
    private static final Map<PluginType, List<String>> FILTER_FIELD_MAP = new ImmutableMap.Builder().put((Object)PluginType.SOURCE, (Object)Lists.newArrayList((Object[])new String[]{"sql", "host"})).put((Object)PluginType.SINK, (Object)Lists.newArrayList((Object[])new String[]{"host", "database", "table"})).build();

    @Override
    public String getDataSourceName() {
        return "JDBC-CLICKHOUSE";
    }

    @Override
    public FormStructure filterOptionRule(String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, BusinessMode businessMode, PluginType pluginType, OptionRule connectorOptionRule, List<RequiredOption> addRequiredOptions, List<Option<?>> addOptionalOptions, List<String> excludedKeys) {
        return super.filterOptionRule(connectorName, dataSourceOptionRule, virtualTableOptionRule, businessMode, pluginType, connectorOptionRule, addRequiredOptions, addOptionalOptions, FILTER_FIELD_MAP.get(pluginType));
    }

    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        switch (businessMode) {
            case DATA_REPLICA: {
                if (pluginType.equals((Object)PluginType.SINK)) {
                    connectorConfig = connectorConfig.withValue(DATABASE, ConfigValueFactory.fromAnyRef((Object)dataSourceOption.getDatabases().get(0)));
                    break;
                }
                throw new UnsupportedOperationException("Clickhouse DATA_REPLICA Unsupported plugin type: " + pluginType);
            }
            case DATA_INTEGRATION: {
                if (pluginType.equals((Object)PluginType.SOURCE)) {
                    List<String> tableFields = selectTableFields.getTableFields();
                    String sql = String.format("SELECT %s FROM %s", String.join((CharSequence)",", tableFields), String.format("`%s`.`%s`", dataSourceOption.getDatabases().get(0), dataSourceOption.getTables().get(0)));
                    connectorConfig = connectorConfig.withValue(SQL, ConfigValueFactory.fromAnyRef((Object)sql));
                    break;
                }
                if (pluginType.equals((Object)PluginType.SINK)) {
                    connectorConfig = connectorConfig.withValue(DATABASE, ConfigValueFactory.fromAnyRef((Object)dataSourceOption.getDatabases().get(0)));
                    connectorConfig = connectorConfig.withValue(TABLE, ConfigValueFactory.fromAnyRef((Object)dataSourceOption.getTables().get(0)));
                    break;
                }
                throw new UnsupportedOperationException("Unsupported plugin type: " + pluginType);
            }
        }
        connectorConfig = connectorConfig.withValue(HOST, ConfigValueFactory.fromAnyRef((Object)JdbcUtils.getAddressFromUrl(dataSourceInstanceConfig.getString(URL))));
        return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }
}

