/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.app.dynamicforms.AbstractFormOption;
import org.apache.seatunnel.app.dynamicforms.FormStructure;

public class FormOptionSort {
    public static FormStructure sortFormStructure(@NonNull FormStructure formStructure) {
        if (formStructure == null) {
            throw new NullPointerException("formStructure is marked non-null but is null");
        }
        ArrayList newFormOptions = new ArrayList();
        List formOptions = formStructure.getForms();
        formOptions.forEach(currFormOption -> {
            if (currFormOption.getShow() != null && currFormOption.getShow().size() > 0) {
                return;
            }
            FormOptionSort.addShowOptionAfter(currFormOption, formOptions, newFormOptions);
        });
        return FormStructure.builder().name(formStructure.getName()).withLocale(formStructure.getLocales()).addFormOption(newFormOptions.toArray(new AbstractFormOption[0])).build();
    }

    public static void addShowOptionAfter(@NonNull AbstractFormOption currFormOption, @NonNull List<AbstractFormOption> allFormOptions, @NonNull List<AbstractFormOption> newFormOptions) {
        if (currFormOption == null) {
            throw new NullPointerException("currFormOption is marked non-null but is null");
        }
        if (allFormOptions == null) {
            throw new NullPointerException("allFormOptions is marked non-null but is null");
        }
        if (newFormOptions == null) {
            throw new NullPointerException("newFormOptions is marked non-null but is null");
        }
        if (newFormOptions.contains(currFormOption)) {
            return;
        }
        newFormOptions.add(currFormOption);
        List showOptions = allFormOptions.stream().filter(nextOption -> nextOption.getShow() != null && nextOption.getShow().size() > 0 && nextOption.getShow().get("field").toString().equals(currFormOption.getField())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(showOptions)) {
            return;
        }
        for (AbstractFormOption showOption : showOptions) {
            FormOptionSort.addShowOptionAfter(showOption, allFormOptions, newFormOptions);
        }
    }
}

