/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.utils;

import java.util.ArrayList;
import java.util.List;

public class CartesianProductUtils {
    public static List<List> cartesianProduct(List ... lists) {
        List<List> first = CartesianProductUtils.transformation(lists[0]);
        for (int i = 0; i < lists.length - 1; ++i) {
            first = CartesianProductUtils.match(first, lists[i + 1]);
        }
        return first;
    }

    private static List<List> match(List<List> lists, List container1) {
        ArrayList<List> r = new ArrayList<List>();
        for (List list : lists) {
            for (Object o : container1) {
                ArrayList list1 = new ArrayList();
                list1.addAll(list);
                list1.add(o);
                r.add(list1);
            }
        }
        return r;
    }

    private static List<List> transformation(List container) {
        ArrayList<List> r = new ArrayList<List>();
        container.forEach(c -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(c);
            r.add(list);
        });
        return r;
    }

    public static String maskPassword(String password) {
        int i;
        int length = password.length();
        if (length == 0) {
            return "";
        }
        if (length == 1) {
            return "*";
        }
        if (length == 2) {
            return "**";
        }
        int maskLength = Math.max(length / 2, 1);
        StringBuilder sb = new StringBuilder(length);
        for (i = 0; i < maskLength; ++i) {
            sb.append("*");
        }
        if (length % 2 == 1) {
            sb.append(password.charAt(maskLength));
            ++maskLength;
        }
        for (i = maskLength; i < length; ++i) {
            sb.append("*");
        }
        return sb.toString();
    }
}

