/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import java.util.ArrayList;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class TablePath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String schemaName;
    @NonNull
    private final String tableName;
    public static final TablePath DEFAULT = TablePath.of("default", "default", "default");

    public TablePath(String databaseName, String schemaName, @NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("tableName cannot be empty");
        }
    }

    public static TablePath of(String fullName) {
        return TablePath.of(fullName, false);
    }

    public static TablePath of(String fullName, boolean schemaFirst) {
        String[] paths = fullName.split("\\.");
        if (paths.length == 1) {
            return TablePath.of(null, paths[0]);
        }
        if (paths.length == 2) {
            if (schemaFirst) {
                return TablePath.of(null, paths[0], paths[1]);
            }
            return TablePath.of(paths[0], null, paths[1]);
        }
        if (paths.length == 3) {
            return TablePath.of(paths[0], paths[1], paths[2]);
        }
        throw new IllegalArgumentException(String.format("Cannot get split '%s' to get databaseName and tableName", fullName));
    }

    public static TablePath of(String databaseName, String tableName) {
        return TablePath.of(databaseName, null, tableName);
    }

    public static TablePath of(String databaseName, String schemaName, String tableName) {
        return new TablePath(databaseName, schemaName, tableName);
    }

    public String getSchemaAndTableName() {
        return this.getNameCommon(null, this.schemaName, this.tableName, null, null);
    }

    public String getSchemaAndTableName(String quote) {
        return this.getNameCommon(null, this.schemaName, this.tableName, quote, quote);
    }

    public String getFullName() {
        return this.getNameCommon(this.databaseName, this.schemaName, this.tableName, null, null);
    }

    public String getFullNameWithQuoted() {
        return this.getFullNameWithQuoted("`");
    }

    public String getFullNameWithQuoted(String quote) {
        return this.getNameCommon(this.databaseName, this.schemaName, this.tableName, quote, quote);
    }

    public String getFullNameWithQuoted(String quoteLeft, String quoteRight) {
        return this.getNameCommon(this.databaseName, this.schemaName, this.tableName, quoteLeft, quoteRight);
    }

    private String getNameCommon(String databaseName, String schemaName, String tableName, String quoteLeft, String quoteRight) {
        ArrayList<String> joinList = new ArrayList<String>();
        quoteLeft = quoteLeft == null ? "" : quoteLeft;
        String string = quoteRight = quoteRight == null ? "" : quoteRight;
        if (databaseName != null) {
            joinList.add(quoteLeft + databaseName + quoteRight);
        }
        if (schemaName != null) {
            joinList.add(quoteLeft + schemaName + quoteRight);
        }
        if (tableName != null) {
            joinList.add(quoteLeft + tableName + quoteRight);
        }
        return String.join((CharSequence)".", joinList);
    }

    public String toString() {
        return this.getFullName();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    @NonNull
    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TablePath)) {
            return false;
        }
        TablePath other = (TablePath)o;
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        return result;
    }
}

