/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.plugin.discovery.seatunnel;

import java.net.URL;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.plugin.discovery.AbstractPluginDiscovery;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;

public class SeaTunnelFactoryDiscovery
extends AbstractPluginDiscovery<Factory> {
    private final Class<? extends Factory> factoryClass;

    public SeaTunnelFactoryDiscovery(Class<? extends Factory> factoryClass) {
        this.factoryClass = factoryClass;
    }

    public SeaTunnelFactoryDiscovery(Class<? extends Factory> factoryClass, BiConsumer<ClassLoader, URL> addURLToClassLoader) {
        super(addURLToClassLoader);
        this.factoryClass = factoryClass;
    }

    @Override
    protected Class<Factory> getPluginBaseClass() {
        return Factory.class;
    }

    @Override
    protected Factory loadPluginInstance(PluginIdentifier pluginIdentifier, ClassLoader classLoader) {
        ServiceLoader<Factory> serviceLoader = ServiceLoader.load(this.getPluginBaseClass(), classLoader);
        for (Factory factory : serviceLoader) {
            String pluginName;
            String factoryIdentifier;
            if (!this.factoryClass.isInstance(factory) || !StringUtils.equalsIgnoreCase((CharSequence)(factoryIdentifier = factory.factoryIdentifier()), (CharSequence)(pluginName = pluginIdentifier.getPluginName()))) continue;
            return factory;
        }
        return null;
    }
}

