/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.app.common.EngineType;
import org.apache.seatunnel.app.dal.dao.IJobInstanceDao;
import org.apache.seatunnel.app.dal.dao.IJobInstanceHistoryDao;
import org.apache.seatunnel.app.dal.dao.IJobMetricsDao;
import org.apache.seatunnel.app.dal.entity.JobInstance;
import org.apache.seatunnel.app.dal.entity.JobInstanceHistory;
import org.apache.seatunnel.app.dal.entity.JobMetrics;
import org.apache.seatunnel.app.domain.response.engine.Engine;
import org.apache.seatunnel.app.domain.response.metrics.JobDAG;
import org.apache.seatunnel.app.domain.response.metrics.JobPipelineDetailMetricsRes;
import org.apache.seatunnel.app.domain.response.metrics.JobPipelineSummaryMetricsRes;
import org.apache.seatunnel.app.domain.response.metrics.JobSummaryMetricsRes;
import org.apache.seatunnel.app.service.IJobMetricsService;
import org.apache.seatunnel.app.service.impl.SeatunnelBaseServiceImpl;
import org.apache.seatunnel.app.thirdparty.engine.SeaTunnelEngineProxy;
import org.apache.seatunnel.app.thirdparty.metrics.EngineMetricsExtractorFactory;
import org.apache.seatunnel.app.thirdparty.metrics.IEngineMetricsExtractor;
import org.apache.seatunnel.app.utils.JobUtils;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.server.common.CodeGenerateUtils;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JobMetricsServiceImpl
extends SeatunnelBaseServiceImpl
implements IJobMetricsService {
    private static final Logger log = LoggerFactory.getLogger(JobMetricsServiceImpl.class);
    @Resource
    private IJobMetricsDao jobMetricsDao;
    @Resource
    private IJobInstanceHistoryDao jobInstanceHistoryDao;
    @Resource
    private IJobInstanceDao jobInstanceDao;

    @Override
    public List<JobPipelineSummaryMetricsRes> getJobPipelineSummaryMetrics(@NonNull Integer userId, @NonNull Long jobInstanceId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobInstanceId == null) {
            throw new NullPointerException("jobInstanceId is marked non-null but is null");
        }
        this.funcPermissionCheck("project:seatunnel-task-instance:summary", userId);
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobInstanceId);
        List<JobMetrics> jobPipelineDetailMetrics = this.getJobPipelineDetailMetrics(jobInstance, userId);
        return this.summaryMetrics(jobPipelineDetailMetrics);
    }

    @Override
    public JobSummaryMetricsRes getJobSummaryMetrics(@NonNull Integer userId, @NonNull Long jobInstanceId, @NonNull String jobEngineId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobInstanceId == null) {
            throw new NullPointerException("jobInstanceId is marked non-null but is null");
        }
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        this.funcPermissionCheck("project:seatunnel-task-instance:summary", userId);
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobInstanceId);
        Engine engine = new Engine(jobInstance.getEngineName(), jobInstance.getEngineVersion());
        IEngineMetricsExtractor engineMetricsExtractor = new EngineMetricsExtractorFactory(engine).getEngineMetricsExtractor();
        JobStatus jobStatus = engineMetricsExtractor.getJobStatus(jobEngineId);
        List<JobMetrics> jobPipelineDetailMetrics = this.getJobPipelineDetailMetrics(jobInstance, userId);
        long readCount = jobPipelineDetailMetrics.stream().mapToLong(JobMetrics::getReadRowCount).sum();
        long writeCount = jobPipelineDetailMetrics.stream().mapToLong(JobMetrics::getWriteRowCount).sum();
        return new JobSummaryMetricsRes(jobInstanceId, Long.parseLong(jobEngineId), readCount, writeCount, jobStatus);
    }

    @Override
    public Map<Long, JobSummaryMetricsRes> getALLJobSummaryMetrics(@NonNull Integer userId, @NonNull Map<Long, Long> jobInstanceIdAndJobEngineIdMap, @NonNull List<Long> jobInstanceIdList, @NonNull JobMode jobMode) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobInstanceIdAndJobEngineIdMap == null) {
            throw new NullPointerException("jobInstanceIdAndJobEngineIdMap is marked non-null but is null");
        }
        if (jobInstanceIdList == null) {
            throw new NullPointerException("jobInstanceIdList is marked non-null but is null");
        }
        if (jobMode == null) {
            throw new NullPointerException("jobMode is marked non-null but is null");
        }
        log.info("jobInstanceIdAndJobEngineIdMap={}", jobInstanceIdAndJobEngineIdMap);
        this.funcPermissionCheck("project:seatunnel-task-instance:summary", userId);
        List<JobInstance> allJobInstance = this.jobInstanceDao.getAllJobInstance(jobInstanceIdList);
        if (allJobInstance.isEmpty()) {
            log.warn("getALLJobSummaryMetrics : allJobInstance is empty, task id list is {}", jobInstanceIdList);
            return new HashMap<Long, JobSummaryMetricsRes>();
        }
        Map<Long, JobSummaryMetricsRes> result = null;
        Map<Long, HashMap<Integer, JobMetrics>> allRunningJobMetricsFromEngine = this.getAllRunningJobMetricsFromEngine(allJobInstance.get(0).getEngineName(), allJobInstance.get(0).getEngineVersion());
        if (JobMode.BATCH == jobMode) {
            result = this.getMatricsListIfTaskTypeIsBatch(allJobInstance, userId, allRunningJobMetricsFromEngine, jobInstanceIdAndJobEngineIdMap);
        } else if (JobMode.STREAMING == jobMode) {
            result = this.getMatricsListIfTaskTypeIsStreaming(allJobInstance, userId, allRunningJobMetricsFromEngine, jobInstanceIdAndJobEngineIdMap);
        }
        log.info("result is {}", (Object)(result == null ? "null" : result.toString()));
        return result;
    }

    private Map<Long, JobSummaryMetricsRes> getMatricsListIfTaskTypeIsBatch(List<JobInstance> allJobInstance, Integer userId, Map<Long, HashMap<Integer, JobMetrics>> allRunningJobMetricsFromEngine, Map<Long, Long> jobInstanceIdAndJobEngineIdMap) {
        HashMap<Long, JobSummaryMetricsRes> jobSummaryMetricsResMap = new HashMap<Long, JobSummaryMetricsRes>();
        log.info("allRunningJobMetricsFromEngine is {}", (Object)allRunningJobMetricsFromEngine.toString());
        for (JobInstance jobInstance : allJobInstance) {
            JobSummaryMetricsRes jobMetricsFromDb;
            log.info("jobEngineId={}", (Object)jobInstance.getJobEngineId());
            if (jobInstance.getJobStatus() == null || jobInstance.getJobStatus() == JobStatus.FAILED || jobInstance.getJobStatus() == JobStatus.RUNNING) {
                if (!allRunningJobMetricsFromEngine.isEmpty() && allRunningJobMetricsFromEngine.containsKey(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId()))) {
                    JobSummaryMetricsRes jobMetricsFromEngineRes = this.getRunningJobMetricsFromEngine(allRunningJobMetricsFromEngine, jobInstanceIdAndJobEngineIdMap, jobInstance);
                    jobSummaryMetricsResMap.put(jobInstance.getId(), jobMetricsFromEngineRes);
                    this.modifyAndUpdateJobInstanceAndJobMetrics(jobInstance, allRunningJobMetricsFromEngine, jobInstanceIdAndJobEngineIdMap, userId);
                    continue;
                }
                log.info("The job does not exist on the engine, it is directly returned from the database");
                jobMetricsFromDb = this.getJobSummaryMetricsResByDb(jobInstance, userId, Long.toString(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId())));
                if (jobMetricsFromDb != null) {
                    jobSummaryMetricsResMap.put(jobInstance.getId(), jobMetricsFromDb);
                }
                if (jobInstance.getJobStatus() != JobStatus.RUNNING) continue;
                jobInstance.setJobStatus(JobStatus.FINISHED);
                this.jobInstanceDao.getJobInstanceMapper().updateById(jobInstance);
                continue;
            }
            if (jobInstance.getJobStatus() != JobStatus.FINISHED && jobInstance.getJobStatus() != JobStatus.CANCELED) continue;
            jobMetricsFromDb = this.getJobSummaryMetricsResByDb(jobInstance, userId, Long.toString(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId())));
            log.info("jobStatus=finish oe canceled,JobSummaryMetricsRes={}", (Object)jobMetricsFromDb);
            jobSummaryMetricsResMap.put(jobInstance.getId(), jobMetricsFromDb);
        }
        return jobSummaryMetricsResMap;
    }

    private void modifyAndUpdateJobInstanceAndJobMetrics(JobInstance jobInstance, Map<Long, HashMap<Integer, JobMetrics>> allRunningJobMetricsFromEngine, Map<Long, Long> jobInstanceIdAndJobEngineIdMap, Integer userId) {
        jobInstance.setJobStatus(JobStatus.RUNNING);
        HashMap<Integer, JobMetrics> jobMetricsFromEngine = allRunningJobMetricsFromEngine.get(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId()));
        List<JobMetrics> jobMetricsFromDb = this.jobMetricsDao.getByInstanceId(jobInstance.getId());
        log.info("001jobMetricsFromDb={}", jobMetricsFromDb);
        if (jobMetricsFromDb.isEmpty()) {
            log.info("002jobMetricsFromDb == null");
            this.syncMetricsToDbRunning(jobInstance, userId, jobMetricsFromEngine);
            this.jobInstanceDao.update(jobInstance);
        } else {
            jobMetricsFromDb.forEach(jobMetrics -> jobMetrics.setReadRowCount(((JobMetrics)jobMetricsFromEngine.get(jobMetrics.getPipelineId())).getReadRowCount()));
            jobMetricsFromDb.forEach(jobMetrics -> jobMetrics.setWriteRowCount(((JobMetrics)jobMetricsFromEngine.get(jobMetrics.getPipelineId())).getWriteRowCount()));
            jobMetricsFromDb.forEach(jobMetrics -> jobMetrics.setStatus(JobStatus.RUNNING));
            this.updateJobInstanceAndMetrics(jobInstance, jobMetricsFromDb);
        }
    }

    private Map<Long, JobSummaryMetricsRes> getMatricsListIfTaskTypeIsStreaming(List<JobInstance> allJobInstance, Integer userId, Map<Long, HashMap<Integer, JobMetrics>> allRunningJobMetricsFromEngine, Map<Long, Long> jobInstanceIdAndJobEngineIdMap) {
        HashMap<Long, JobSummaryMetricsRes> jobSummaryMetricsResMap = new HashMap<Long, JobSummaryMetricsRes>();
        for (JobInstance jobInstance : allJobInstance) {
            try {
                JobSummaryMetricsRes jobMetricsFromEngineRes;
                JobSummaryMetricsRes jobMetricsFromDb;
                if (jobInstance.getJobStatus() != null && jobInstance.getJobStatus() == JobStatus.CANCELED) {
                    jobMetricsFromDb = this.getJobSummaryMetricsResByDb(jobInstance, userId, Long.toString(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId())));
                    jobSummaryMetricsResMap.put(jobInstance.getId(), jobMetricsFromDb);
                    continue;
                }
                if (jobInstance.getJobStatus() != null && (jobInstance.getJobStatus() == JobStatus.FINISHED || jobInstance.getJobStatus() == JobStatus.FAILED)) {
                    if (!allRunningJobMetricsFromEngine.isEmpty() && allRunningJobMetricsFromEngine.containsKey(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId()))) {
                        this.modifyAndUpdateJobInstanceAndJobMetrics(jobInstance, allRunningJobMetricsFromEngine, jobInstanceIdAndJobEngineIdMap, userId);
                        jobMetricsFromEngineRes = this.getRunningJobMetricsFromEngine(allRunningJobMetricsFromEngine, jobInstanceIdAndJobEngineIdMap, jobInstance);
                        jobSummaryMetricsResMap.put(jobInstance.getId(), jobMetricsFromEngineRes);
                        continue;
                    }
                    jobMetricsFromDb = this.getJobSummaryMetricsResByDb(jobInstance, userId, Long.toString(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId())));
                    jobSummaryMetricsResMap.put(jobInstance.getId(), jobMetricsFromDb);
                    continue;
                }
                if (!allRunningJobMetricsFromEngine.isEmpty() && allRunningJobMetricsFromEngine.containsKey(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId()))) {
                    this.modifyAndUpdateJobInstanceAndJobMetrics(jobInstance, allRunningJobMetricsFromEngine, jobInstanceIdAndJobEngineIdMap, userId);
                    jobMetricsFromEngineRes = this.getRunningJobMetricsFromEngine(allRunningJobMetricsFromEngine, jobInstanceIdAndJobEngineIdMap, jobInstance);
                    jobSummaryMetricsResMap.put(jobInstance.getId(), jobMetricsFromEngineRes);
                    continue;
                }
                JobStatus jobStatus = null;
                try {
                    jobStatus = this.getJobStatusByJobEngineId(String.valueOf(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId())));
                }
                catch (Exception e) {
                    log.warn("getMetricsListIfTaskTypeIsStreaming getJobStatusByJobEngineId is exception jobInstanceId is : {}", (Object)jobInstance.getId());
                }
                if (jobStatus == null) continue;
                jobInstance.setJobStatus(jobStatus);
                this.jobInstanceDao.update(jobInstance);
                JobSummaryMetricsRes jobSummaryMetricsResByDb = this.getJobSummaryMetricsResByDb(jobInstance, userId, String.valueOf(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId())));
                jobSummaryMetricsResMap.put(jobInstance.getId(), jobSummaryMetricsResByDb);
                List<JobMetrics> jobMetricsFromDb2 = this.getJobMetricsFromDb(jobInstance, userId, String.valueOf(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId())));
                if (jobMetricsFromDb2.isEmpty()) continue;
                JobStatus finalJobStatusByJobEngineId = jobStatus;
                jobMetricsFromDb2.forEach(jobMetrics -> jobMetrics.setStatus(finalJobStatusByJobEngineId));
                for (JobMetrics jobMetrics2 : jobMetricsFromDb2) {
                    this.jobMetricsDao.getJobMetricsMapper().updateById(jobMetrics2);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return jobSummaryMetricsResMap;
    }

    private JobSummaryMetricsRes getRunningJobMetricsFromEngine(Map<Long, HashMap<Integer, JobMetrics>> allRunningJobMetricsFromEngine, Map<Long, Long> jobInstanceIdAndJobEngineIdMap, JobInstance jobInstance) {
        HashMap<Integer, JobMetrics> jobMetricsFromEngine = allRunningJobMetricsFromEngine.get(jobInstanceIdAndJobEngineIdMap.get(jobInstance.getId()));
        log.info("0706jobMetricsFromEngine={}", jobMetricsFromEngine);
        long readCount = jobMetricsFromEngine.values().stream().mapToLong(JobMetrics::getReadRowCount).sum();
        long writeCount = jobMetricsFromEngine.values().stream().mapToLong(JobMetrics::getWriteRowCount).sum();
        log.info("jobInstance={}", (Object)jobInstance);
        return new JobSummaryMetricsRes(jobInstance.getId(), 1L, readCount, writeCount, JobStatus.RUNNING);
    }

    private JobSummaryMetricsRes getJobSummaryMetricsResByDb(JobInstance jobInstance, Integer userId, String jobEngineId) {
        List<JobMetrics> jobMetricsFromDb = this.getJobMetricsFromDb(jobInstance, userId, jobEngineId);
        if (!jobMetricsFromDb.isEmpty()) {
            long readCount = jobMetricsFromDb.stream().mapToLong(JobMetrics::getReadRowCount).sum();
            long writeCount = jobMetricsFromDb.stream().mapToLong(JobMetrics::getWriteRowCount).sum();
            return new JobSummaryMetricsRes(jobInstance.getId(), Long.parseLong(jobInstance.getJobEngineId()), readCount, writeCount, jobInstance.getJobStatus());
        }
        return null;
    }

    private Map<Long, HashMap<Integer, JobMetrics>> getAllRunningJobMetricsFromEngine(EngineType engineName, String engineVersion) {
        Engine engine = new Engine(engineName, engineVersion);
        IEngineMetricsExtractor engineMetricsExtractor = new EngineMetricsExtractorFactory(engine).getEngineMetricsExtractor();
        return engineMetricsExtractor.getAllRunningJobMetrics();
    }

    private void updateJobInstanceAndMetrics(JobInstance jobInstance, List<JobMetrics> jobMetrics) {
        if (jobInstance != null && jobMetrics != null) {
            this.jobInstanceDao.update(jobInstance);
            for (JobMetrics jobMetric : jobMetrics) {
                this.jobMetricsDao.getJobMetricsMapper().updateById(jobMetric);
            }
        }
    }

    private JobStatus getJobStatusByJobEngineId(String jobEngineId) {
        return SeaTunnelEngineProxy.getInstance().getJobStatus(jobEngineId);
    }

    private Map<Integer, JobMetrics> getJobMetricsFromEngineMap(@NonNull JobInstance jobInstance, @NonNull String jobEngineId) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        log.info("enter getJobMetricsFromEngine");
        Engine engine = new Engine(jobInstance.getEngineName(), jobInstance.getEngineVersion());
        IEngineMetricsExtractor engineMetricsExtractor = new EngineMetricsExtractorFactory(engine).getEngineMetricsExtractor();
        return engineMetricsExtractor.getMetricsByJobEngineIdRTMap(jobEngineId);
    }

    private List<JobMetrics> getJobPipelineDetailMetrics(@NonNull JobInstance jobInstance, @NonNull Integer userId) {
        List<JobMetrics> jobMetrics;
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (JobUtils.isJobEndStatus(jobInstance.getJobStatus())) {
            jobMetrics = this.getJobMetricsFromDb(jobInstance, userId, jobInstance.getJobEngineId());
            if (CollectionUtils.isEmpty(jobMetrics) && !(jobMetrics = this.getJobMetricsFromEngine(jobInstance, jobInstance.getJobEngineId())).isEmpty()) {
                this.syncMetricsToDb(jobInstance, userId, jobInstance.getJobEngineId());
            }
        } else {
            jobMetrics = this.getJobMetricsFromEngine(jobInstance, jobInstance.getJobEngineId());
        }
        return jobMetrics;
    }

    @Override
    public List<JobPipelineDetailMetricsRes> getJobPipelineDetailMetricsRes(@NonNull Integer userId, @NonNull Long jobInstanceId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobInstanceId == null) {
            throw new NullPointerException("jobInstanceId is marked non-null but is null");
        }
        this.funcPermissionCheck("project:seatunnel-task-instance:detail", userId);
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobInstanceId);
        List<JobMetrics> jobPipelineDetailMetrics = this.getJobPipelineDetailMetrics(jobInstance, userId);
        return jobPipelineDetailMetrics.stream().map(this::wrapperJobMetrics).collect(Collectors.toList());
    }

    @Override
    public JobDAG getJobDAG(@NonNull Integer userId, @NonNull Long jobInstanceId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobInstanceId == null) {
            throw new NullPointerException("jobInstanceId is marked non-null but is null");
        }
        this.funcPermissionCheck("project:seatunnel-task-instance:dag", userId);
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobInstanceId);
        String jobEngineId = jobInstance.getJobEngineId();
        JobInstanceHistory history = this.getJobHistoryFromDb(jobInstance, userId, jobEngineId);
        if (history != null) {
            String dag = history.getDag();
            return (JobDAG)JsonUtils.parseObject((String)dag, JobDAG.class);
        }
        Engine engine = new Engine(jobInstance.getEngineName(), jobInstance.getEngineVersion());
        IEngineMetricsExtractor engineMetricsExtractor = new EngineMetricsExtractorFactory(engine).getEngineMetricsExtractor();
        if (engineMetricsExtractor.isJobEnd(jobEngineId)) {
            this.syncHistoryJobInfoToDb(jobInstance, jobEngineId);
            history = this.getJobHistoryFromDb(jobInstance, userId, jobEngineId);
        } else {
            history = this.getJobHistoryFromEngine(jobInstance, jobEngineId);
        }
        if (history != null) {
            String dag = history.getDag();
            return (JobDAG)JsonUtils.parseObject((String)dag, JobDAG.class);
        }
        return null;
    }

    private JobInstanceHistory getJobHistoryFromEngine(@NonNull JobInstance jobInstance, String jobEngineId) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        Engine engine = new Engine(jobInstance.getEngineName(), jobInstance.getEngineVersion());
        IEngineMetricsExtractor engineMetricsExtractor = new EngineMetricsExtractorFactory(engine).getEngineMetricsExtractor();
        return engineMetricsExtractor.getJobHistoryById(jobEngineId);
    }

    private JobInstanceHistory getJobHistoryFromDb(@NonNull JobInstance jobInstance, Integer userId, String jobEngineId) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        this.relationJobInstanceAndJobEngineId(jobInstance, userId, jobEngineId);
        return this.jobInstanceHistoryDao.getByInstanceId(jobInstance.getId());
    }

    @Override
    public void syncJobDataToDb(@NonNull JobInstance jobInstance, @NonNull Integer userId, @NonNull String jobEngineId) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        this.relationJobInstanceAndJobEngineId(jobInstance, userId, jobEngineId);
        this.syncMetricsToDb(jobInstance, userId, jobEngineId);
        this.syncHistoryJobInfoToDb(jobInstance, jobEngineId);
        this.syncCompleteJobInfoToDb(jobInstance);
    }

    private void syncMetricsToDb(@NonNull JobInstance jobInstance, @NonNull Integer userId, @NonNull String jobEngineId) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        Map<Integer, JobMetrics> jobMetricsFromEngineMap = this.getJobMetricsFromEngineMap(jobInstance, jobEngineId);
        List<JobMetrics> jobMetricsFromDb = this.getJobMetricsFromDb(jobInstance, userId, jobEngineId);
        if (jobMetricsFromDb.isEmpty()) {
            List<JobMetrics> jobMetricsFromEngine = Arrays.asList(jobMetricsFromEngineMap.values().toArray(new JobMetrics[0]));
            jobMetricsFromEngine.forEach(metrics -> {
                try {
                    metrics.setId(CodeGenerateUtils.getInstance().genCode());
                }
                catch (CodeGenerateUtils.CodeGenerateException e) {
                    throw new SeatunnelException(SeatunnelErrorEnum.JOB_RUN_GENERATE_UUID_ERROR);
                }
                metrics.setJobInstanceId(jobInstance.getId());
                metrics.setCreateUserId(userId);
                metrics.setUpdateUserId(userId);
            });
            if (!jobMetricsFromEngine.isEmpty()) {
                this.jobMetricsDao.getJobMetricsMapper().insertBatchMetrics(jobMetricsFromEngine);
            }
        } else {
            JobStatus jobStatus = this.getJobStatusByJobEngineId(jobEngineId);
            for (JobMetrics jobMetrics : jobMetricsFromDb) {
                Integer pipelineId = jobMetrics.getPipelineId();
                JobMetrics currentPiplinejobMetricsFromEngine = jobMetricsFromEngineMap.get(pipelineId);
                jobMetrics.setWriteQps(currentPiplinejobMetricsFromEngine.getWriteQps());
                jobMetrics.setReadQps(currentPiplinejobMetricsFromEngine.getReadQps());
                jobMetrics.setReadRowCount(currentPiplinejobMetricsFromEngine.getReadRowCount());
                jobMetrics.setWriteRowCount(currentPiplinejobMetricsFromEngine.getWriteRowCount());
                jobMetrics.setStatus(jobStatus);
                this.jobMetricsDao.getJobMetricsMapper().updateById(jobMetrics);
            }
        }
    }

    private void syncHistoryJobInfoToDb(@NonNull JobInstance jobInstance, @NonNull String jobEngineId) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        JobInstanceHistory jobHistoryFromEngine = this.getJobHistoryFromEngine(jobInstance, jobEngineId);
        jobHistoryFromEngine.setId(jobInstance.getId());
        JobInstanceHistory byInstanceId = this.jobInstanceHistoryDao.getByInstanceId(jobInstance.getId());
        if (byInstanceId == null) {
            this.jobInstanceHistoryDao.insert(jobHistoryFromEngine);
        } else {
            this.jobInstanceHistoryDao.updateJobInstanceHistory(jobHistoryFromEngine);
        }
    }

    private void syncCompleteJobInfoToDb(@NonNull JobInstance jobInstance) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        jobInstance.setEndTime(new Date());
        this.jobInstanceDao.update(jobInstance);
    }

    private void relationJobInstanceAndJobEngineId(@NonNull JobInstance jobInstance, @NonNull Integer userId, @NonNull String jobEngineId) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        if (StringUtils.isEmpty((CharSequence)jobInstance.getJobEngineId())) {
            jobInstance.setJobEngineId(jobEngineId);
            jobInstance.setUpdateUserId(userId);
            this.jobInstanceDao.update(jobInstance);
        }
    }

    private List<JobMetrics> getJobMetricsFromEngine(@NonNull JobInstance jobInstance, @NonNull String jobEngineId) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        Engine engine = new Engine(jobInstance.getEngineName(), jobInstance.getEngineVersion());
        IEngineMetricsExtractor engineMetricsExtractor = new EngineMetricsExtractorFactory(engine).getEngineMetricsExtractor();
        return engineMetricsExtractor.getMetricsByJobEngineId(jobEngineId);
    }

    private List<JobPipelineSummaryMetricsRes> summaryMetrics(@NonNull List<JobMetrics> jobPipelineDetailedMetrics) {
        if (jobPipelineDetailedMetrics == null) {
            throw new NullPointerException("jobPipelineDetailedMetrics is marked non-null but is null");
        }
        return jobPipelineDetailedMetrics.stream().map(metrics -> new JobPipelineSummaryMetricsRes(metrics.getPipelineId().intValue(), metrics.getReadRowCount(), metrics.getWriteRowCount(), metrics.getStatus())).collect(Collectors.toList());
    }

    private List<JobMetrics> getJobMetricsFromDb(@NonNull JobInstance jobInstance, @NonNull Integer userId, @NonNull String jobEngineId) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        this.relationJobInstanceAndJobEngineId(jobInstance, userId, jobEngineId);
        return this.jobMetricsDao.getByInstanceId(jobInstance.getId());
    }

    @Override
    public ImmutablePair<Long, String> getInstanceIdAndEngineId(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (!key.contains("::") || key.split("::").length != 2) {
            throw new SeatunnelException(SeatunnelErrorEnum.JOB_METRICS_QUERY_KEY_ERROR, new Object[]{key});
        }
        String[] split = key.split("::");
        Long jobInstanceId = Long.valueOf(split[0]);
        String jobEngineId = split[1];
        return new ImmutablePair((Object)jobInstanceId, (Object)jobEngineId);
    }

    private JobPipelineDetailMetricsRes wrapperJobMetrics(@NonNull JobMetrics metrics) {
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        return new JobPipelineDetailMetricsRes(metrics.getId(), metrics.getPipelineId(), metrics.getReadRowCount(), metrics.getWriteRowCount(), metrics.getSourceTableNames(), metrics.getSinkTableNames(), metrics.getReadQps(), metrics.getWriteQps(), metrics.getRecordDelay(), metrics.getStatus());
    }

    private void syncMetricsToDbRunning(@NonNull JobInstance jobInstance, @NonNull Integer userId, @NonNull Map<Integer, JobMetrics> jobMetricsMap) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (jobMetricsMap == null) {
            throw new NullPointerException("jobMetricsMap is marked non-null but is null");
        }
        ArrayList<JobMetrics> list = new ArrayList<JobMetrics>();
        for (Map.Entry<Integer, JobMetrics> entry : jobMetricsMap.entrySet()) {
            JobMetrics jobMetrics = entry.getValue();
            jobMetrics.setId(CodeGenerateUtils.getInstance().genCode());
            jobMetrics.setJobInstanceId(jobInstance.getId());
            jobMetrics.setCreateUserId(userId);
            jobMetrics.setUpdateUserId(userId);
            list.add(jobMetrics);
        }
        if (!list.isEmpty()) {
            log.info("003list={}", list);
            this.jobMetricsDao.getJobMetricsMapper().insertBatchMetrics(list);
        }
    }
}

