/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableFieldRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.AbstractDataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;

@AutoService(value={DataSourceConfigSwitcher.class})
public class PostgresCDCDataSourceConfigSwitcher
extends AbstractDataSourceConfigSwitcher {
    private int three = 3;
    private int two = 2;
    private static final String FACTORY = "factory";
    private static final String CATALOG = "catalog";
    private static final String TABLE_NAMES = "table-names";
    private static final String DATABASE_NAMES = "database-names";
    private static final String FORMAT_KEY = "format";
    private static final String DEBEZIUM_FORMAT = "COMPATIBLE_DEBEZIUM_JSON";
    private static final String DEFAULT_FORMAT = "DEFAULT";
    private static final String SCHEMA = "schema";

    @Override
    public String getDataSourceName() {
        return "POSTGRES-CDC";
    }

    @Override
    public FormStructure filterOptionRule(String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, BusinessMode businessMode, PluginType pluginType, OptionRule connectorOptionRule, List<RequiredOption> addRequiredOptions, List<Option<?>> addOptionalOptions, List<String> excludedKeys) {
        if (PluginType.SOURCE.equals((Object)pluginType)) {
            excludedKeys.add(DATABASE_NAMES);
            excludedKeys.add(TABLE_NAMES);
            if (businessMode.equals((Object)BusinessMode.DATA_INTEGRATION)) {
                excludedKeys.add(FORMAT_KEY);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported plugin type: " + pluginType);
        }
        return super.filterOptionRule(connectorName, dataSourceOptionRule, virtualTableOptionRule, businessMode, pluginType, connectorOptionRule, addRequiredOptions, addOptionalOptions, excludedKeys);
    }

    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        if (PluginType.SOURCE.equals((Object)pluginType)) {
            Config config = ConfigFactory.empty();
            config = config.withValue(FACTORY, ConfigValueFactory.fromAnyRef((Object)"Postgres"));
            connectorConfig = connectorConfig.withValue(CATALOG, (ConfigValue)config.root());
            connectorConfig = connectorConfig.withValue(DATABASE_NAMES, (ConfigValue)ConfigValueFactory.fromIterable(dataSourceOption.getDatabases()));
            connectorConfig = connectorConfig.withValue(TABLE_NAMES, (ConfigValue)ConfigValueFactory.fromIterable(this.mergeDatabaseAndTables(dataSourceOption)));
            if (businessMode.equals((Object)BusinessMode.DATA_INTEGRATION)) {
                connectorConfig = connectorConfig.withValue(FORMAT_KEY, ConfigValueFactory.fromAnyRef((Object)DEFAULT_FORMAT));
            } else if (businessMode.equals((Object)BusinessMode.DATA_REPLICA) && connectorConfig.getString(FORMAT_KEY).toUpperCase(Locale.ROOT).equals(DEBEZIUM_FORMAT)) {
                connectorConfig = connectorConfig.withValue(SCHEMA, (ConfigValue)this.generateDebeziumFormatSchema().root());
            }
        } else {
            throw new UnsupportedOperationException("Unsupported plugin type: " + pluginType);
        }
        return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }

    private Config generateDebeziumFormatSchema() {
        ArrayList<VirtualTableFieldRes> fieldResList = new ArrayList<VirtualTableFieldRes>();
        fieldResList.add(new VirtualTableFieldRes("topic", "string", false, null, false, "", ""));
        fieldResList.add(new VirtualTableFieldRes("key", "string", false, null, false, "", ""));
        fieldResList.add(new VirtualTableFieldRes("value", "string", false, null, false, "", ""));
        Config schema = ConfigFactory.empty();
        for (VirtualTableFieldRes virtualTableFieldRes : fieldResList) {
            schema = schema.withValue(virtualTableFieldRes.getFieldName(), ConfigValueFactory.fromAnyRef((Object)virtualTableFieldRes.getFieldType()));
        }
        return schema.atKey("fields");
    }

    private List<String> mergeDatabaseAndTables(DataSourceOption dataSourceOption) {
        ArrayList<String> tables = new ArrayList<String>();
        dataSourceOption.getDatabases().forEach(database -> dataSourceOption.getTables().forEach(table -> {
            String[] tableFragments = table.split("\\.");
            if (tableFragments.length == this.three) {
                tables.add((String)table);
            } else if (tableFragments.length == this.two) {
                tables.add(this.getDatabaseAndTable((String)database, (String)table));
            } else {
                throw new IllegalArgumentException("Illegal postgres table-name: " + table);
            }
        }));
        return tables;
    }

    private String getDatabaseAndTable(String database, String table) {
        return String.format("%s.%s", database, table);
    }
}

