/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.metrics;

import org.apache.seatunnel.app.common.EngineType;
import org.apache.seatunnel.app.domain.response.engine.Engine;
import org.apache.seatunnel.app.thirdparty.engine.SeaTunnelEngineMetricsExtractor;
import org.apache.seatunnel.app.thirdparty.metrics.IEngineMetricsExtractor;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;

public class EngineMetricsExtractorFactory {
    private final Engine engine;

    public IEngineMetricsExtractor getEngineMetricsExtractor() {
        if (this.engine.getName() == EngineType.SeaTunnel) {
            return SeaTunnelEngineMetricsExtractor.getInstance();
        }
        throw new SeatunnelException(SeatunnelErrorEnum.UNSUPPORTED_ENGINE, new Object[]{this.engine.getName(), this.engine.getVersion()});
    }

    public Engine getEngine() {
        return this.engine;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EngineMetricsExtractorFactory)) {
            return false;
        }
        EngineMetricsExtractorFactory other = (EngineMetricsExtractorFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Engine this$engine = this.getEngine();
        Engine other$engine = other.getEngine();
        return !(this$engine == null ? other$engine != null : !((Object)this$engine).equals(other$engine));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EngineMetricsExtractorFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Engine $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : ((Object)$engine).hashCode());
        return result;
    }

    public String toString() {
        return "EngineMetricsExtractorFactory(engine=" + this.getEngine() + ")";
    }

    public EngineMetricsExtractorFactory(Engine engine) {
        this.engine = engine;
    }
}

