/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterDataTypeReader
implements ParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterDataTypeReader.class);
    private final TypeNameExtractor nameExtractor;
    private final TypeResolver resolver;

    @Autowired
    public ParameterDataTypeReader(TypeNameExtractor nameExtractor, TypeResolver resolver) {
        this.nameExtractor = nameExtractor;
        this.resolver = resolver;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterContext context) {
        ResolvedMethodParameter methodParameter = context.resolvedMethodParameter();
        ResolvedType parameterType = methodParameter.getParameterType();
        parameterType = context.alternateFor(parameterType);
        ModelRef modelRef = null;
        if (methodParameter.hasParameterAnnotation(PathVariable.class) && this.treatAsAString(parameterType)) {
            parameterType = this.resolver.resolve(String.class, new Type[0]);
            modelRef = new ModelRef("string");
        } else if (methodParameter.hasParameterAnnotation(RequestParam.class) && Maps.isMapType((ResolvedType)parameterType)) {
            modelRef = new ModelRef("", (ModelReference)new ModelRef("string"), true);
        } else if (methodParameter.hasParameterAnnotation(RequestParam.class) && this.treatRequestParamAsString(parameterType)) {
            parameterType = this.resolver.resolve(String.class, new Type[0]);
            modelRef = new ModelRef("string");
        }
        if (!methodParameter.hasParameterAnnotations()) {
            String typeName = Types.typeNameFor((Type)parameterType.getErasedType());
            if (Types.isBaseType((String)typeName)) {
                modelRef = new ModelRef(typeName);
            } else {
                LOG.warn("Trying to infer dataType {}", (Object)parameterType);
            }
        }
        ModelContext modelContext = ModelContext.inputParam((Type)parameterType, (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getGenericNamingStrategy(), (ImmutableSet)context.getIgnorableParameterTypes());
        context.parameterBuilder().type(parameterType).modelRef((ModelReference)Optional.fromNullable((Object)modelRef).or(ResolvedTypes.modelRefFactory((ModelContext)modelContext, (TypeNameExtractor)this.nameExtractor).apply((Object)parameterType)));
    }

    private boolean treatRequestParamAsString(ResolvedType parameterType) {
        return this.treatAsAString(parameterType) && !Collections.isContainerType((ResolvedType)parameterType) || Collections.isContainerType((ResolvedType)parameterType) && this.treatAsAString(Collections.collectionElementType((ResolvedType)parameterType));
    }

    private boolean treatAsAString(ResolvedType parameterType) {
        return !Types.isBaseType((String)Types.typeNameFor((Type)parameterType.getErasedType())) && !parameterType.getErasedType().isEnum();
    }
}

