/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPSubsystemRemoveGroupAvailabilityListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.spi.impl.eventservice.EventService;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class RemoveCPGroupAvailabilityListenerMessageTask
extends AbstractAsyncMessageTask<UUID, Boolean> {
    public RemoveCPGroupAvailabilityListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<Boolean> processInternal() {
        UUID registrationId = (UUID)this.parameters;
        this.endpoint.removeDestroyAction(registrationId);
        EventService eventService = this.clientEngine.getEventService();
        return eventService.deregisterListenerAsync(this.getServiceName(), "availability", registrationId);
    }

    @Override
    protected UUID decodeClientMessage(ClientMessage clientMessage) {
        return CPSubsystemRemoveGroupAvailabilityListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return CPSubsystemRemoveGroupAvailabilityListenerCodec.encodeResponse((Boolean)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

