/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobProxy;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public class JetInstanceImpl
extends AbstractJetInstance<Address> {
    private final NodeEngineImpl nodeEngine;
    private final JetConfig config;

    JetInstanceImpl(HazelcastInstanceImpl hazelcastInstance, JetConfig config) {
        super(hazelcastInstance);
        this.nodeEngine = hazelcastInstance.node.getNodeEngine();
        this.config = config;
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        return this.config;
    }

    @Override
    public Address getMasterId() {
        return Preconditions.checkNotNull(this.nodeEngine.getMasterAddress(), "Cluster has not elected a master");
    }

    @Override
    public Map<Address, GetJobIdsOperation.GetJobIdsResult> getJobsInt(String onlyName, Long onlyJobId) {
        HashMap futures = new HashMap();
        Address masterAddress = null;
        Collection<Member> targetMembers = onlyName == null ? this.nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR) : Collections.singleton(this.nodeEngine.getClusterService().getMembers().iterator().next());
        for (Member member : targetMembers) {
            if (masterAddress == null) {
                masterAddress = member.getAddress();
            }
            GetJobIdsOperation operation = new GetJobIdsOperation(onlyName, onlyJobId);
            InvocationFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)operation, member.getAddress()).invoke();
            futures.put(member.getAddress(), future);
        }
        HashMap<Address, GetJobIdsOperation.GetJobIdsResult> res = new HashMap<Address, GetJobIdsOperation.GetJobIdsResult>(futures.size());
        for (Map.Entry en : futures.entrySet()) {
            GetJobIdsOperation.GetJobIdsResult result;
            try {
                result = (GetJobIdsOperation.GetJobIdsResult)((CompletableFuture)en.getValue()).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                result = GetJobIdsOperation.GetJobIdsResult.EMPTY;
            }
            catch (ExecutionException e) {
                if (!((Address)en.getKey()).equals(masterAddress) && (e.getCause() instanceof TargetNotMemberException || e.getCause() instanceof MemberLeftException)) {
                    result = GetJobIdsOperation.GetJobIdsResult.EMPTY;
                }
                throw new RuntimeException("Error when getting job IDs: " + e, e);
            }
            res.put((Address)en.getKey(), result);
        }
        return res;
    }

    @Override
    public void shutdown() {
        try {
            JetServiceBackend jetServiceBackend = (JetServiceBackend)this.nodeEngine.getService("hz:impl:jetService");
            jetServiceBackend.shutDownJobs();
            super.shutdown();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
        return this.nodeEngine.getProxyService().existsDistributedObject(serviceName, objectName);
    }

    @Override
    public Job newJobProxy(long jobId, Address lightJobCoordinator) {
        return new JobProxy(this.nodeEngine, jobId, lightJobCoordinator);
    }

    @Override
    public Job newJobProxy(long jobId, boolean isLightJob, @Nonnull Object jobDefinition, @Nonnull JobConfig config) {
        return new JobProxy(this.nodeEngine, jobId, isLightJob, jobDefinition, config);
    }

    @Override
    public ILogger getLogger() {
        return this.nodeEngine.getLogger(this.getClass());
    }
}

