/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions.geohash;

import org.apache.spark.sql.sedona_sql.expressions.geohash.BBox;
import org.apache.spark.sql.sedona_sql.expressions.geohash.GeoHashUpdate;
import org.locationtech.jts.geom.Point;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class PointGeoHashEncoder$ {
    public static final PointGeoHashEncoder$ MODULE$;
    private final String base32;
    private final Seq<Object> bits;

    static {
        new PointGeoHashEncoder$();
    }

    private String base32() {
        return this.base32;
    }

    private Seq<Object> bits() {
        return this.bits;
    }

    public String calculateGeoHash(Point geom, long precision) {
        BBox bbox = new BBox(-180.0, 180.0, -90.0, 90.0);
        long precisionUpdated = package$.MODULE$.min(precision, 20L);
        return precision <= 0L ? "" : this.geoHashAggregate(geom, precisionUpdated, 0L, "", true, bbox, 0, 0);
    }

    private String geoHashAggregate(Point point, long precision, long currentPrecision, String geoHash, boolean isEven, BBox bbox, int bit, int ch) {
        while (currentPrecision < precision) {
            GeoHashUpdate geoHashUpdate;
            GeoHashUpdate geoHashUpdate2;
            if (isEven) {
                double mid = (bbox.startLon() + bbox.endLon()) / 2.0;
                if (point.getX() >= mid) {
                    geoHashUpdate2 = new GeoHashUpdate(bbox.copy(mid, bbox.copy$default$2(), bbox.copy$default$3(), bbox.copy$default$4()), ch | BoxesRunTime.unboxToInt((Object)this.bits().apply(bit)));
                } else {
                    double x$1 = mid;
                    double x$2 = bbox.copy$default$1();
                    double x$3 = bbox.copy$default$3();
                    double x$4 = bbox.copy$default$4();
                    geoHashUpdate2 = new GeoHashUpdate(bbox.copy(x$2, x$1, x$3, x$4), ch);
                }
            } else {
                double mid = (bbox.startLat() + bbox.endLat()) / 2.0;
                if (point.getY() >= mid) {
                    double x$5 = mid;
                    double x$6 = bbox.copy$default$1();
                    double x$7 = bbox.copy$default$2();
                    double x$8 = bbox.copy$default$4();
                    geoHashUpdate2 = new GeoHashUpdate(bbox.copy(x$6, x$7, x$5, x$8), ch | BoxesRunTime.unboxToInt((Object)this.bits().apply(bit)));
                } else {
                    double x$9 = mid;
                    double x$10 = bbox.copy$default$1();
                    double x$11 = bbox.copy$default$2();
                    double x$12 = bbox.copy$default$3();
                    geoHashUpdate2 = geoHashUpdate = new GeoHashUpdate(bbox.copy(x$10, x$11, x$12, x$9), ch);
                }
            }
            if (bit < 4) {
                ch = geoHashUpdate.ch();
                ++bit;
                bbox = geoHashUpdate.bbox();
                isEven = !isEven;
                continue;
            }
            String geoHashUpdated = new StringBuilder().append((Object)geoHash).append((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.base32()), geoHashUpdate.ch()))).toString();
            ch = 0;
            bit = 0;
            bbox = geoHashUpdate.bbox();
            isEven = !isEven;
            geoHash = geoHashUpdated;
            ++currentPrecision;
        }
        return geoHash;
    }

    private PointGeoHashEncoder$() {
        MODULE$ = this;
        this.base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
        this.bits = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{16, 8, 4, 2, 1}));
    }
}

