/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.flink.expressions;

import java.util.List;
import java.util.Objects;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.sedona.common.utils.GeomUtils;
import org.apache.sedona.common.utils.HalfOpenRectangle;
import org.apache.sedona.core.spatialPartitioning.PartitioningUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class Predicates {

    public static class ST_OrderingEquals
    extends ScalarFunction {
        private List<Envelope> grids;

        public ST_OrderingEquals(PartitioningUtils partitioner) {
            this.grids = partitioner.fetchLeafZones();
        }

        public ST_OrderingEquals() {
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return geom1.equalsExact(geom2);
        }
    }

    public static class ST_Disjoint
    extends ScalarFunction {
        private List<Envelope> grids;

        public ST_Disjoint(PartitioningUtils partitioner) {
            this.grids = partitioner.fetchLeafZones();
        }

        public ST_Disjoint() {
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return geom1.disjoint(geom2);
        }
    }

    public static class ST_CoveredBy
    extends ScalarFunction {
        private List<Envelope> grids;

        public ST_CoveredBy(PartitioningUtils partitioner) {
            this.grids = partitioner.fetchLeafZones();
        }

        public ST_CoveredBy() {
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return geom1.coveredBy(geom2);
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="INT") Integer key, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Objects.requireNonNull(this.grids, "This predicate has to be initialized by a partitioner.");
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            HalfOpenRectangle halfOpenRectangle = new HalfOpenRectangle(this.grids.get(key));
            return !GeomUtils.isDuplicate((Geometry)geom1, (Geometry)geom2, (HalfOpenRectangle)halfOpenRectangle) && geom1.coveredBy(geom2);
        }
    }

    public static class ST_Covers
    extends ScalarFunction {
        private List<Envelope> grids;

        public ST_Covers(PartitioningUtils partitioner) {
            this.grids = partitioner.fetchLeafZones();
        }

        public ST_Covers() {
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return geom1.covers(geom2);
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="INT") Integer key, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Objects.requireNonNull(this.grids, "This predicate has to be initialized by a partitioner.");
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            HalfOpenRectangle halfOpenRectangle = new HalfOpenRectangle(this.grids.get(key));
            return !GeomUtils.isDuplicate((Geometry)geom1, (Geometry)geom2, (HalfOpenRectangle)halfOpenRectangle) && geom1.covers(geom2);
        }
    }

    public static class ST_Within
    extends ScalarFunction {
        private List<Envelope> grids;

        public ST_Within(PartitioningUtils partitioner) {
            this.grids = partitioner.fetchLeafZones();
        }

        public ST_Within() {
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return geom1.within(geom2);
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="INT") Integer key, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Objects.requireNonNull(this.grids, "This predicate has to be initialized by a partitioner.");
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            HalfOpenRectangle halfOpenRectangle = new HalfOpenRectangle(this.grids.get(key));
            return !GeomUtils.isDuplicate((Geometry)geom1, (Geometry)geom2, (HalfOpenRectangle)halfOpenRectangle) && geom1.within(geom2);
        }
    }

    public static class ST_Contains
    extends ScalarFunction {
        private List<Envelope> grids;

        public ST_Contains(PartitioningUtils partitioner) {
            this.grids = partitioner.fetchLeafZones();
        }

        public ST_Contains() {
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return geom1.contains(geom2);
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="INT") Integer key, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Objects.requireNonNull(this.grids, "This predicate has to be initialized by a partitioner.");
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            HalfOpenRectangle halfOpenRectangle = new HalfOpenRectangle(this.grids.get(key));
            return !GeomUtils.isDuplicate((Geometry)geom1, (Geometry)geom2, (HalfOpenRectangle)halfOpenRectangle) && geom1.contains(geom2);
        }
    }

    public static class ST_Intersects
    extends ScalarFunction {
        private List<Envelope> grids;

        public ST_Intersects(PartitioningUtils partitioner) {
            this.grids = partitioner.fetchLeafZones();
        }

        public ST_Intersects() {
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            return geom1.intersects(geom2);
        }

        @DataTypeHint(value="Boolean")
        public Boolean eval(@DataTypeHint(value="INT") Integer key, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o1, @DataTypeHint(value="RAW", bridgedTo=Geometry.class) Object o2) {
            Objects.requireNonNull(this.grids, "This predicate has to be initialized by a partitioner.");
            Geometry geom1 = (Geometry)o1;
            Geometry geom2 = (Geometry)o2;
            HalfOpenRectangle halfOpenRectangle = new HalfOpenRectangle(this.grids.get(key));
            return !GeomUtils.isDuplicate((Geometry)geom1, (Geometry)geom2, (HalfOpenRectangle)halfOpenRectangle) && geom1.intersects(geom2);
        }
    }
}

