/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.python.wrapper.translation;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.sedona.common.geometryObjects.Circle;
import org.apache.sedona.python.wrapper.SerializationException;
import org.apache.sedona.python.wrapper.SerializationException$;
import org.apache.sedona.python.wrapper.translation.CircleSerializer;
import org.apache.sedona.python.wrapper.translation.GeometrySerializer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBReader;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005-3Q!\u0002\u0004\u0001\u0015IAQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-BQA\u0010\u0001\u0005\u0002}BQA\u0010\u0001\u0005\u0002\t\u0013\u0001\u0004U=uQ>tw)Z8nKR\u0014\u0018pU3sS\u0006d\u0017N_3s\u0015\t9\u0001\"A\u0006ue\u0006t7\u000f\\1uS>t'BA\u0005\u000b\u0003\u001d9(/\u00199qKJT!a\u0003\u0007\u0002\rALH\u000f[8o\u0015\tia\"\u0001\u0004tK\u0012|g.\u0019\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xmE\u0002\u0001'e\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e$\u001d\tY\u0012E\u0004\u0002\u001dA5\tQD\u0003\u0002\u001f?\u00051AH]8piz\u001a\u0001!C\u0001\u0017\u0013\t\u0011S#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011*#\u0001D*fe&\fG.\u001b>bE2,'B\u0001\u0012\u0016\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002*\u00015\ta!A\u0005tKJL\u0017\r\\5{KR\u0011AF\r\t\u0004)5z\u0013B\u0001\u0018\u0016\u0005\u0015\t%O]1z!\t!\u0002'\u0003\u00022+\t!!)\u001f;f\u0011\u0015\u0019$\u00011\u00015\u0003!9Wm\\7fiJL\bCA\u001b=\u001b\u00051$BA\u001c9\u0003\u00119Wm\\7\u000b\u0005eR\u0014a\u00016ug*\u00111\bE\u0001\rY>\u001c\u0017\r^5p]R,7\r[\u0005\u0003{Y\u0012\u0001bR3p[\u0016$(/_\u0001\fI\u0016\u001cXM]5bY&TX\r\u0006\u00025\u0001\")\u0011i\u0001a\u0001Y\u00051a/\u00197vKN$B\u0001N\"I\u0013\")A\t\u0002a\u0001\u000b\u0006A\u0011n]\"je\u000edW\r\u0005\u0002\u0015\r&\u0011q)\u0006\u0002\u0004\u0013:$\b\"B!\u0005\u0001\u0004a\u0003\"\u0002&\u0005\u0001\u0004)\u0015AB8gMN,G\u000f")
public class PythonGeometrySerializer
implements Serializable {
    public byte[] serialize(Geometry geometry) {
        byte[] byArray;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Circle) {
            Circle circle = (Circle)geometry2;
            byArray = new CircleSerializer(circle).serialize();
        } else {
            byArray = new GeometrySerializer(geometry).serialize();
        }
        return byArray;
    }

    public Geometry deserialize(byte[] values) {
        byte isCircle = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(values)));
        return this.deserialize(isCircle, values, 1);
    }

    public Geometry deserialize(int isCircle, byte[] values, int offset) {
        Geometry geometry;
        WKBReader reader = new WKBReader();
        if (isCircle == 1) {
            Geometry geom = reader.read((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(values), offset + 8, values.length));
            double radius = ByteBuffer.wrap((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(values), offset, offset + 8)).getDouble();
            geometry = new Circle(geom, Predef$.MODULE$.double2Double(radius));
        } else if (isCircle == 0) {
            geometry = reader.read((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(values), offset, values.length));
        } else {
            throw new SerializationException("Can not deserialize object", SerializationException$.MODULE$.apply$default$2());
        }
        return geometry;
    }
}

