/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.monitoring;

import java.io.Serializable;
import org.apache.spark.Success$;
import org.apache.spark.TaskEndReason;
import org.apache.spark.scheduler.AccumulableInfo;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i3A\u0001C\u0005\u0001)!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003BB\u001b\u0001A\u0003%1\u0005C\u00047\u0001\t\u0007I\u0011B\u001c\t\r!\u0003\u0001\u0015!\u00039\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0005!a\u0015n\u001d;f]\u0016\u0014(B\u0001\u0006\f\u0003)iwN\\5u_JLgn\u001a\u0006\u0003\u00195\tAaY8sK*\u0011abD\u0001\u0007g\u0016$wN\\1\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001775\tqC\u0003\u0002\u00193\u0005I1o\u00195fIVdWM\u001d\u0006\u00035=\tQa\u001d9be.L!\u0001H\f\u0003\u001bM\u0003\u0018M]6MSN$XM\\3s\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t\u0011\"\u0001\u0007d_VtG/\u001a:OC6,7/F\u0001$!\r!3&L\u0007\u0002K)\u0011aeJ\u0001\nS6lW\u000f^1cY\u0016T!\u0001K\u0015\u0002\u0015\r|G\u000e\\3di&|gNC\u0001+\u0003\u0015\u00198-\u00197b\u0013\taSEA\u0002TKF\u0004\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\t1\fgn\u001a\u0006\u0002e\u0005!!.\u0019<b\u0013\t!tF\u0001\u0004TiJLgnZ\u0001\u000eG>,h\u000e^3s\u001d\u0006lWm\u001d\u0011\u0002\u0017Q\f7o[\"qkRKW.Z\u000b\u0002qA!\u0011\b\u0010 F\u001b\u0005Q$BA\u001e(\u0003\u001diW\u000f^1cY\u0016L!!\u0010\u001e\u0003\u00075\u000b\u0007\u000f\u0005\u0003@\u0001\n\u0013U\"A\u0015\n\u0005\u0005K#A\u0002+va2,'\u0007\u0005\u0002/\u0007&\u0011Ai\f\u0002\b\u0013:$XmZ3s!\tyd)\u0003\u0002HS\t!Aj\u001c8h\u00031!\u0018m]6DaV$\u0016.\\3!\u0003%yg\u000eV1tW\u0016sG\r\u0006\u0002L\u001dB\u0011q\bT\u0005\u0003\u001b&\u0012A!\u00168ji\")qJ\u0002a\u0001!\u00069A/Y:l\u000b:$\u0007C\u0001\fR\u0013\t\u0011vC\u0001\u000bTa\u0006\u00148\u000eT5ti\u0016tWM\u001d+bg.,e\u000eZ\u0001\u0011_:\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012$\"aS+\t\u000bY;\u0001\u0019A,\u0002\u001dM$\u0018mZ3D_6\u0004H.\u001a;fIB\u0011a\u0003W\u0005\u00033^\u00111d\u00159be.d\u0015n\u001d;f]\u0016\u00148\u000b^1hK\u000e{W\u000e\u001d7fi\u0016$\u0007")
public class Listener
extends SparkListener {
    private final Seq<String> counterNames = new .colon.colon((Object)"buildCount", (List)new .colon.colon((Object)"streamCount", (List)new .colon.colon((Object)"candidateCount", (List)new .colon.colon((Object)"resultCount", (List)Nil$.MODULE$))));
    private final Map<Tuple2<Integer, Integer>, Object> taskCpuTime = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

    private Seq<String> counterNames() {
        return this.counterNames;
    }

    private Map<Tuple2<Integer, Integer>, Object> taskCpuTime() {
        return this.taskCpuTime;
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        TaskEndReason taskEndReason = taskEnd.reason();
        Success$ success$ = Success$.MODULE$;
        if (!(taskEndReason != null ? !taskEndReason.equals(success$) : success$ != null)) {
            long cpuTime = taskEnd.taskMetrics().executorCpuTime();
            int partitionId = Integer.parseInt(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(taskEnd.taskInfo().id()), '.')[0]);
            this.taskCpuTime().update((Object)new Tuple2((Object)Predef$.MODULE$.int2Integer(taskEnd.stageId()), (Object)Predef$.MODULE$.int2Integer(partitionId)), (Object)BoxesRunTime.boxToLong((long)cpuTime));
            return;
        }
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        HashMap accumulables = stageCompleted.stageInfo().accumulables();
        if (Listener.getCounterOption$1("buildCount", accumulables).isDefined()) {
            int stageId = stageCompleted.stageInfo().stageId();
            scala.collection.immutable.Map buildCounts = (scala.collection.immutable.Map)Listener.getCounter$1("buildCount", accumulables);
            scala.collection.immutable.Map streamCounts = (scala.collection.immutable.Map)Listener.getCounter$1("streamCount", accumulables);
            scala.collection.immutable.Map candidateCounts = (scala.collection.immutable.Map)Listener.getCounter$1("candidateCount", accumulables);
            scala.collection.immutable.Map resultCounts = (scala.collection.immutable.Map)Listener.getCounter$1("resultCount", accumulables);
            List stats = (List)((IterableOnceOps)buildCounts.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int partitionId = tuple2._1$mcI$sp();
                    long buildCount = tuple2._2$mcJ$sp();
                    long streamCount = BoxesRunTime.unboxToLong((Object)streamCounts.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
                    long candidateCount = BoxesRunTime.unboxToLong((Object)candidateCounts.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
                    long resultCount = BoxesRunTime.unboxToLong((Object)resultCounts.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
                    long cpuTime = BoxesRunTime.unboxToLong((Object)this.taskCpuTime().getOrElse((Object)new Tuple2((Object)Predef$.MODULE$.int2Integer(stageId), (Object)Predef$.MODULE$.int2Integer(partitionId)), (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
                    return new Tuple6((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)BoxesRunTime.boxToLong((long)buildCount), (Object)BoxesRunTime.boxToLong((long)streamCount), (Object)BoxesRunTime.boxToLong((long)candidateCount), (Object)BoxesRunTime.boxToLong((long)resultCount), (Object)BoxesRunTime.boxToLong((long)cpuTime));
                }
                throw new MatchError((Object)tuple2);
            })).toList().sortBy((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)Listener.$anonfun$onStageCompleted$7(x0$2)), (Ordering)Ordering.Long$.MODULE$);
            Console$.MODULE$.out().println("Spatial join is complete. Execution statistics:");
            Console$.MODULE$.out().println("Partition\t CPU Time (s)\tBuild ##\tStream ##\tCandidates ##\tResults ##");
            stats.foreach((Function1 & Serializable)x0$3 -> {
                Listener.$anonfun$onStageCompleted$8(x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$onStageCompleted$1(String name$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AccumulableInfo v = (AccumulableInfo)tuple2._2();
            Option option = v.name();
            Some some = new Some((Object)new StringBuilder(19).append("sedona.spatialjoin.").append(name$1).toString());
            return !(option != null ? !option.equals(some) : some != null);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Option getCounterOption$1(String name, HashMap accumulables$1) {
        return accumulables$1.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Listener.$anonfun$onStageCompleted$1(name, x0$1)));
    }

    private static final Object getCounter$1(String name, HashMap accumulables$1) {
        return ((AccumulableInfo)((Tuple2)Listener.getCounterOption$1(name, accumulables$1).get())._2()).value().get();
    }

    public static final /* synthetic */ long $anonfun$onStageCompleted$7(Tuple6 x0$2) {
        Tuple6 tuple6 = x0$2;
        if (tuple6 != null) {
            long cpuTime = BoxesRunTime.unboxToLong((Object)tuple6._6());
            return cpuTime;
        }
        throw new MatchError((Object)tuple6);
    }

    public static final /* synthetic */ void $anonfun$onStageCompleted$8(Tuple6 x0$3) {
        Tuple6 tuple6 = x0$3;
        if (tuple6 != null) {
            int partitionId = BoxesRunTime.unboxToInt((Object)tuple6._1());
            long buildCount = BoxesRunTime.unboxToLong((Object)tuple6._2());
            long streamCount = BoxesRunTime.unboxToLong((Object)tuple6._3());
            long candidateCount = BoxesRunTime.unboxToLong((Object)tuple6._4());
            long resultCount = BoxesRunTime.unboxToLong((Object)tuple6._5());
            long cpuTime = BoxesRunTime.unboxToLong((Object)tuple6._6());
            Console$.MODULE$.out().println(new StringBuilder(0).append(StringOps$.MODULE$.format$extension("% 10d\t% 10d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToLong((long)(cpuTime / 1000L))}))).append(StringOps$.MODULE$.format$extension("% 10d\t% 10d\t% 10d\t% 10d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)buildCount), BoxesRunTime.boxToLong((long)streamCount), BoxesRunTime.boxToLong((long)candidateCount), BoxesRunTime.boxToLong((long)resultCount)}))).toString());
            return;
        }
        throw new MatchError((Object)tuple6);
    }
}

