/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;

public class Sinusoidal
extends AbstractTransformBuilder
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "sinusoidal";
    }

    @Override
    public ProjectionCT makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double centralMeridian = this.readAttributeDouble(ctv, "longitude_of_central_meridian", Double.NaN);
        double false_easting = this.readAttributeDouble(ctv, "false_easting", 0.0);
        double false_northing = this.readAttributeDouble(ctv, "false_northing", 0.0);
        double earth_radius = this.getEarthRadiusInKm(ctv);
        if (false_easting != 0.0 || false_northing != 0.0) {
            double scalef = Sinusoidal.getFalseEastingScaleFactor(geoCoordinateUnits);
            false_easting *= scalef;
            false_northing *= scalef;
        }
        ucar.unidata.geoloc.projection.Sinusoidal proj = new ucar.unidata.geoloc.projection.Sinusoidal(centralMeridian, false_easting, false_northing, earth_radius);
        return new ProjectionCT(ctv.getName(), "FGDC", proj);
    }
}

