/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.elasticsearch.jest;

import com.google.gson.Gson;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.util.List;
import org.apache.http.HttpHost;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.jest.HttpClientConfigBuilderCustomizer;
import org.springframework.boot.autoconfigure.elasticsearch.jest.JestProperties;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={JestClient.class})
@EnableConfigurationProperties(value={JestProperties.class})
@AutoConfigureAfter(value={GsonAutoConfiguration.class})
public class JestAutoConfiguration {
    private final JestProperties properties;
    private final ObjectProvider<Gson> gsonProvider;
    private final List<HttpClientConfigBuilderCustomizer> builderCustomizers;

    public JestAutoConfiguration(JestProperties properties, ObjectProvider<Gson> gson, ObjectProvider<List<HttpClientConfigBuilderCustomizer>> builderCustomizers) {
        this.properties = properties;
        this.gsonProvider = gson;
        this.builderCustomizers = (List)builderCustomizers.getIfAvailable();
    }

    @Bean(destroyMethod="shutdownClient")
    @ConditionalOnMissingBean
    public JestClient jestClient() {
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(this.createHttpClientConfig());
        return factory.getObject();
    }

    protected HttpClientConfig createHttpClientConfig() {
        Gson gson;
        String proxyHost;
        HttpClientConfig.Builder builder = new HttpClientConfig.Builder(this.properties.getUris());
        if (StringUtils.hasText((String)this.properties.getUsername())) {
            builder.defaultCredentials(this.properties.getUsername(), this.properties.getPassword());
        }
        if (StringUtils.hasText((String)(proxyHost = this.properties.getProxy().getHost()))) {
            Integer proxyPort = this.properties.getProxy().getPort();
            Assert.notNull((Object)proxyPort, (String)"Proxy port must not be null");
            builder.proxy(new HttpHost(proxyHost, proxyPort.intValue()));
        }
        if ((gson = (Gson)this.gsonProvider.getIfUnique()) != null) {
            builder.gson(gson);
        }
        builder.multiThreaded(this.properties.isMultiThreaded());
        ((HttpClientConfig.Builder)builder.connTimeout(this.properties.getConnectionTimeout())).readTimeout(this.properties.getReadTimeout());
        this.customize(builder);
        return builder.build();
    }

    private void customize(HttpClientConfig.Builder builder) {
        if (this.builderCustomizers != null) {
            for (HttpClientConfigBuilderCustomizer customizer : this.builderCustomizers) {
                customizer.customize(builder);
            }
        }
    }
}

