/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.executor.context;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.infra.context.Reloadable;
import org.apache.shardingsphere.elasticjob.infra.context.ReloadablePostProcessor;
import org.apache.shardingsphere.elasticjob.infra.spi.ElasticJobServiceLoader;

public final class ExecutorContext {
    private final Map<String, Reloadable<?>> reloadableItems = new LinkedHashMap();

    public ExecutorContext(JobConfiguration jobConfig) {
        ServiceLoader.load(Reloadable.class).forEach(each -> ElasticJobServiceLoader.newTypedServiceInstance(Reloadable.class, (String)each.getType(), (Properties)new Properties()).ifPresent(reloadable -> this.reloadableItems.put(reloadable.getType(), (Reloadable<?>)reloadable)));
        this.initReloadable(jobConfig);
    }

    private void initReloadable(JobConfiguration jobConfig) {
        this.reloadableItems.values().stream().filter(each -> each instanceof ReloadablePostProcessor).forEach(each -> ((ReloadablePostProcessor)each).init(jobConfig));
    }

    public void reloadIfNecessary(JobConfiguration jobConfiguration) {
        this.reloadableItems.values().forEach(each -> each.reloadIfNecessary(jobConfiguration));
    }

    public <T> T get(Class<T> targetClass) {
        return (T)this.reloadableItems.get(targetClass.getName()).getInstance();
    }

    public void shutdown() {
        for (Reloadable<?> each : this.reloadableItems.values()) {
            try {
                each.close();
            }
            catch (IOException iOException) {}
        }
    }

    static {
        ElasticJobServiceLoader.registerTypedService(Reloadable.class);
    }
}

