/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.service;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.disable.app.DisableAppService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.disable.job.DisableJobService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.failover.FailoverService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.failover.FailoverTaskInfo;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.ready.ReadyService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.running.RunningService;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class FacadeService {
    private static final Logger log = LoggerFactory.getLogger(FacadeService.class);
    @Autowired
    private CloudJobConfigurationService jobConfigService;
    @Autowired
    private ReadyService readyService;
    @Autowired
    private RunningService runningService;
    @Autowired
    private FailoverService failoverService;
    @Autowired
    private DisableAppService disableAppService;
    @Autowired
    private DisableJobService disableJobService;

    public void addTransient(String jobName) {
        this.readyService.addTransient(jobName);
    }

    public Optional<CloudJobConfigurationPOJO> load(String jobName) {
        return this.jobConfigService.load(jobName);
    }

    public Map<String, Integer> getAllReadyTasks() {
        return this.readyService.getAllReadyTasks();
    }

    public Map<String, Set<TaskContext>> getAllRunningTasks() {
        return this.runningService.getAllRunningTasks();
    }

    public Map<String, Collection<FailoverTaskInfo>> getAllFailoverTasks() {
        return this.failoverService.getAllFailoverTasks();
    }

    public boolean isJobDisabled(String jobName) {
        Optional<CloudJobConfigurationPOJO> jobConfiguration = this.jobConfigService.load(jobName);
        return !jobConfiguration.isPresent() || this.disableAppService.isDisabled(jobConfiguration.get().getAppName()) || this.disableJobService.isDisabled(jobName);
    }

    public void enableJob(String jobName) {
        this.disableJobService.remove(jobName);
    }

    public void disableJob(String jobName) {
        this.disableJobService.add(jobName);
    }
}

